/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveFix;
import ldinsp.check.LDICheckSolveHint;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawEdit;
import ldinsp.ldraw.LDrawPart;

public class LDICFilenameOMR
extends LDICheck {
    private static final Pattern VALID_FILENAME_PATTERN = Pattern.compile("^([a-z0-9]+)(-[a-z0-9]+)? - (.*)", 2);
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private ArrayList<LDICheckSolve> solver;

    public LDICFilenameOMR(LDIContext ctx, LDrawPart part) {
        String chkFilename;
        StringBuffer lrsb = new StringBuffer();
        boolean plainLdr = false;
        this.solver = new ArrayList();
        if (part.loadedFromFilename == null) {
            chkFilename = part.givenFilename;
        } else {
            chkFilename = this.getLeafFilename(part.loadedFromFilename);
            if (!chkFilename.toLowerCase().endsWith(".mpd")) {
                this.resState = LDICheckState.HINT;
                if (part.givenFilename != null || part.subParts != null && part.subParts.size() > 0) {
                    lrsb.append("file has sub-parts but filename does not end with .mpd\n");
                } else if (chkFilename.toLowerCase().endsWith(".ldr")) {
                    lrsb.append("filename ends with .ldr, skipping sub-filename checks\n");
                    plainLdr = true;
                }
            }
        }
        Matcher matcher = VALID_FILENAME_PATTERN.matcher(chkFilename);
        if (!matcher.matches()) {
            this.resShort = "error: filename does not comply with OMR naming\n";
            lrsb.append("filename \"" + chkFilename + "\" is not in OMR-format (set-optqual - name.mpd), skip further name tests\n");
            this.resState = LDICheckState.ERROR;
            this.solver.add(new LDICheckSolveHint("OMR name", "Filenames must be in format \"set-optqual - name.mpd\" like \"10246 - Detectives Office.mpd\""));
        } else {
            String setId = matcher.group(1);
            try {
                Integer.parseInt(setId);
            }
            catch (NumberFormatException e) {
                lrsb.append("hint: set id \"" + setId + "\" contains non-numeric chars, which is very unlikely\n");
                this.resState = this.resState.combine(LDICheckState.HINT);
            }
            String optQualStr = matcher.group(2);
            if (optQualStr != null && optQualStr.length() > 1) {
                optQualStr = optQualStr.substring(1);
                try {
                    int optQual = Integer.parseInt(optQualStr);
                    if (optQual == 0) {
                        lrsb.append("optional qualifier is 0 (use only if it is greater than 1)\n");
                        this.resState = LDICheckState.ERROR;
                    } else if (optQual == 1) {
                        lrsb.append("hint: optional qualifier is 1 (use only if it is greater than 1)\n");
                        this.resState = this.resState.combine(LDICheckState.HINT);
                    }
                }
                catch (NumberFormatException e) {
                    lrsb.append("optional qualifier \"" + optQualStr + "\" contains non-numeric chars\n");
                    this.resState = LDICheckState.ERROR;
                }
                setId = String.valueOf(setId) + "-" + optQualStr;
            }
            final ArrayList<RenameInfo> rename = new ArrayList<RenameInfo>();
            if (!plainLdr) {
                String prefix = String.valueOf(setId) + " - ";
                this.doCheckFilenameOMR(part, prefix, lrsb, rename);
                if (part.subParts != null) {
                    for (LDrawPart sb : part.subParts) {
                        this.doCheckFilenameOMR(sb, prefix, lrsb, rename);
                    }
                }
            }
            this.resShort = this.resState == LDICheckState.OK ? "  ok : all filenames comply with OMR naming\n" : (this.resState == LDICheckState.HINT ? " hint: maybe at least one filename could be optimized\n" : "error: at least one (sub)filename does not comply with OMR naming\n");
            if (rename.size() > 0) {
                this.solver = new ArrayList();
                this.solver.add(new LDICheckSolveFix("Rename", "Rename " + rename.size() + " filenames", true){

                    @Override
                    public int fix() {
                        int cnt = 0;
                        for (RenameInfo ri : rename) {
                            cnt += LDrawEdit.renamePart(ri.part, ri.to, true);
                        }
                        return cnt;
                    }
                });
            }
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    private void doCheckFilenameOMR(LDrawPart sb, String prefix, StringBuffer lrsb, ArrayList<RenameInfo> rename) {
        String filename = sb.givenFilename;
        if (filename == null) {
            lrsb.append("missing filename\n");
            this.resState = LDICheckState.ERROR;
            return;
        }
        String lcf = filename.toLowerCase();
        if (!lcf.endsWith(".ldr") && !lcf.endsWith(".dat")) {
            lrsb.append("filename " + filename + " does not end with .dat or .ldr\n");
            this.resState = LDICheckState.ERROR;
        }
        if (!filename.startsWith(prefix)) {
            lrsb.append("filename " + filename + " does not start with parent OMR prefix \"" + prefix + "\"\n");
            this.resState = LDICheckState.ERROR;
            rename.add(new RenameInfo(sb, String.valueOf(prefix) + filename));
        }
    }

    private String getLeafFilename(String filename) {
        int lastSlash = filename.replace('\\', '/').lastIndexOf(47);
        if (lastSlash < 0) {
            return filename;
        }
        return filename.substring(lastSlash + 1);
    }

    private static class RenameInfo {
        private LDrawPart part;
        private String to;

        private RenameInfo(LDrawPart ipart, String ito) {
            this.part = ipart;
            this.to = ito;
        }
    }
}

