/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ldraw;

import ldinsp.base.LDIWorker;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawMatrix;
import ldinsp.ldraw.LDrawPart;

public class LDrawLinePartRef
extends LDrawLine {
    public final int colId;
    public final LDrawMatrix trans;
    public final String refname;

    public LDrawLinePartRef(LDrawPart iowner, int ilineNr, String isource, int icolId, LDrawMatrix itrans, String irefname) {
        super(iowner, ilineNr, isource);
        this.colId = icolId;
        this.trans = itrans;
        this.refname = irefname;
    }

    @Override
    public void work(LDIWorker w, LDrawMatrix m, int pcol) {
        LDrawPart target = w.handlePartRef(this, this.refname, this.colId, pcol);
        if (target != null) {
            boolean oldInvertAll = w.getInvertAll();
            boolean oldInvertExtra = w.getInvertExtra();
            if (w.getInvertNext()) {
                w.setInvertAll(!oldInvertAll);
                w.setInvertNext(false);
            }
            LDrawMatrix dm = m.mul(this.trans);
            w.setInvertExtra(dm.det < 0.0);
            int dpcol = this.colId == 16 ? pcol : this.colId;
            w.work(target, false, dm, dpcol);
            w.setInvertAll(oldInvertAll);
            w.setInvertExtra(oldInvertExtra);
        }
        w.setInvertNext(false);
    }

    @Override
    public LDrawLine copy(LDrawPart newOwner, int newLineNr) {
        return new LDrawLinePartRef(newOwner, newLineNr, this.source, this.colId, this.trans, this.refname);
    }

    public String getSourceForReplacedRef(String newRefname) {
        if (this.source == null || newRefname == null) {
            return null;
        }
        int index = this.source.toLowerCase().lastIndexOf(this.refname.toLowerCase());
        if (index < 0) {
            return this.source;
        }
        return this.source.substring(0, index).concat(newRefname);
    }
}

