/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ldraw;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ldinsp.base.LDILogger;
import ldinsp.ldraw.LDrawConvertException;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLineBfcCmd;
import ldinsp.ldraw.LDrawLineColor;
import ldinsp.ldraw.LDrawLineColorHint;
import ldinsp.ldraw.LDrawLineFile;
import ldinsp.ldraw.LDrawLineLine;
import ldinsp.ldraw.LDrawLineOther;
import ldinsp.ldraw.LDrawLineParMeta;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawLineQuad;
import ldinsp.ldraw.LDrawLineStep;
import ldinsp.ldraw.LDrawLineTri;
import ldinsp.ldraw.LDrawMatrix;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;
import ldinsp.ldraw.LDrawPoint;

public class LDrawFiles {
    private static final String PAT_SEP = "\\s+";
    private static final String PAT_COLOR = "([0-9a-fx]+)";
    private static final String PAT_FLOAT = "([-.0-9e]+)";
    private static final String PAT_NAME = "(\\S+)";
    private static final String PAT_STRING = "(.*)";
    private static final String PAT_COLHINT = "(\\S+ID)";
    private static final String PAT_PARMTYPE = "([^\\[\\]]+)";
    private static final String PAT_PARMOPTS = "((?:\\s*\\[[^\\[\\]]*\\])*)";
    private static final String PAT_POPTSINT = "\\[([^\\[\\]=]*)(?:=([^\\[\\]]*))?\\]";
    private static final String PAT_LINEEND = "\\s*(//.*)?\\Z";
    private static Pattern filePattern = Pattern.compile("0\\s+file\\s+(.*)\\s*(//.*)?\\Z", 2);
    private static Pattern bfcPattern = Pattern.compile("0\\s+bfc\\s+(.*)\\s*(//.*)?\\Z", 2);
    private static Pattern colHintPattern = Pattern.compile("0\\s+// (\\S+ID)\\s+(.*)\\s*(//.*)?\\Z", 2);
    private static Pattern colPattern = Pattern.compile("0\\s+!colour\\s+(\\S+)\\s+code\\s+([0-9a-fx]+)\\s+(.*)\\s*(//.*)?\\Z", 2);
    private static Pattern stepNormPattern = Pattern.compile("0\\s+step\\s*(//.*)?\\Z", 2);
    private static Pattern stepRotWCoordPattern = Pattern.compile("0\\s+rotstep\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+(abs|rel|add)\\s*(//.*)?\\Z", 2);
    private static Pattern stepRotEndPattern = Pattern.compile("0\\s+rotstep\\s+end\\s*(//.*)?\\Z", 2);
    private static Pattern parMetaPattern = Pattern.compile("0\\s+(!LDCAD|!LDINSP)\\s+([^\\[\\]]+)\\s+((?:\\s*\\[[^\\[\\]]*\\])*)\\s*(//.*)?\\Z", 2);
    private static Pattern parMetaOptions = Pattern.compile("\\[([^\\[\\]=]*)(?:=([^\\[\\]]*))?\\]");
    private static Pattern partrefPattern = Pattern.compile("1\\s+([0-9a-fx]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+(.*)\\s*(//.*)?\\Z", 2);
    private static Pattern linePattern = Pattern.compile("2\\s+([0-9a-fx]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s*(//.*)?\\Z", 2);
    private static Pattern triPattern = Pattern.compile("3\\s+([0-9a-fx]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s*(//.*)?\\Z", 2);
    private static Pattern quadPattern = Pattern.compile("4\\s+([0-9a-fx]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s*(//.*)?\\Z", 2);
    private static Pattern auxLinePattern = Pattern.compile("5\\s+([0-9a-fx]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s+([-.0-9e]+)\\s*(//.*)?\\Z", 2);

    public static void writePart(LDrawPart part, PrintWriter pw) throws IOException {
        if (part == null) {
            return;
        }
        for (LDrawLine line : part.headers) {
            pw.print(line.source);
            pw.print("\r\n");
        }
        for (LDrawLine line : part.actions) {
            pw.print(line.source);
            pw.print("\r\n");
        }
        if (part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                LDrawFiles.writePart(sb, pw);
            }
        }
    }

    public static LDrawPart parseDef(String filename, BufferedReader br, LDrawPartOrigin origin, LDILogger logger) throws IOException {
        return LDrawFiles.parseDef(filename, br, origin, logger, false);
    }

    public static LDrawPart parseDef(String filename, BufferedReader br, LDrawPartOrigin origin, LDILogger logger, boolean onlyMainHeader) throws IOException {
        String line;
        LDrawPart me;
        me.owner = me = new LDrawPart();
        LDrawPart main = me;
        filename.replace('\\', '/');
        int lastSlash = filename.lastIndexOf(47);
        if (lastSlash >= 0) {
            filename = filename.substring(lastSlash + 1);
        }
        me.loadedFromFilename = filename;
        main.origin = origin;
        int lineNr = 0;
        boolean first = true;
        boolean header = true;
        block19: while ((line = br.readLine()) != null) {
            if (!header && onlyMainHeader) break;
            ++lineNr;
            if ((line = line.trim()).length() == 0 || line.equals("0")) {
                LDrawLineOther action = new LDrawLineOther(main, lineNr, line);
                if (header) {
                    me.headers.add(action);
                    continue;
                }
                me.actions.add(action);
                continue;
            }
            try {
                LDrawLine action;
                Matcher matcher;
                block51: {
                    LDrawLineStep step;
                    block52: {
                        LDrawLineStep.StepType type;
                        String typeStr;
                        if (line.charAt(0) != '0') break block51;
                        matcher = filePattern.matcher(line);
                        if (matcher.matches()) {
                            if (first) {
                                first = false;
                            } else {
                                me = new LDrawPart();
                                me.owner = main;
                                me.origin = LDrawPartOrigin.SELF;
                                if (main.subParts == null) {
                                    main.subParts = new ArrayList();
                                }
                                main.subParts.add(me);
                                header = true;
                            }
                            me.givenFilename = LDrawFiles.getLDrawString(matcher, 1);
                            me.headers.add(new LDrawLineFile(main, lineNr, line, me.givenFilename));
                            continue;
                        }
                        matcher = bfcPattern.matcher(line);
                        if (matcher.matches()) {
                            action = new LDrawLineBfcCmd(main, lineNr, line, LDrawFiles.getLDrawTrimmedStrings(matcher, 1));
                            if (action.isCw() || action.isCcw()) {
                                if (action.isCw()) {
                                    me.isCw = true;
                                }
                                me.headers.add(action);
                                continue;
                            }
                            header = false;
                            me.actions.add(action);
                            continue;
                        }
                        matcher = colHintPattern.matcher(line);
                        if (matcher.matches()) {
                            header = false;
                            action = new LDrawLineColorHint(main, lineNr, line, LDrawFiles.getLDrawString(matcher, 1), LDrawFiles.getLDrawString(matcher, 2));
                            me.actions.add(action);
                            continue;
                        }
                        matcher = colPattern.matcher(line);
                        if (matcher.matches()) {
                            header = false;
                            action = new LDrawLineColor(main, lineNr, line, LDrawFiles.getLDrawString(matcher, 1), LDrawFiles.getLDrawColor(matcher, 2), LDrawFiles.getLDrawTrimmedStrings(matcher, 3));
                            me.actions.add(action);
                            continue;
                        }
                        matcher = stepNormPattern.matcher(line);
                        if (matcher.matches()) {
                            header = false;
                            step = new LDrawLineStep(main, lineNr, line, LDrawLineStep.StepType.NORMAL, null);
                            me.actions.add(step);
                            me.steps.add(step);
                            continue;
                        }
                        matcher = stepRotWCoordPattern.matcher(line);
                        if (!matcher.matches()) break block52;
                        header = false;
                        switch (typeStr = LDrawFiles.getLDrawString(matcher, 4).toUpperCase()) {
                            case "ABS": {
                                type = LDrawLineStep.StepType.ROT_ABS;
                                break;
                            }
                            case "REL": {
                                type = LDrawLineStep.StepType.ROT_REL;
                                break;
                            }
                            case "ADD": {
                                type = LDrawLineStep.StepType.ROT_ADD;
                                break;
                            }
                            default: {
                                throw new LDrawConvertException("unknown rotation step type: " + typeStr);
                            }
                        }
                        LDrawLineStep step2 = new LDrawLineStep(main, lineNr, line, type, LDrawFiles.getLDrawPoint(matcher, 1));
                        me.actions.add(step2);
                        me.steps.add(step2);
                        continue;
                    }
                    matcher = stepRotEndPattern.matcher(line);
                    if (matcher.matches()) {
                        header = false;
                        step = new LDrawLineStep(main, lineNr, line, LDrawLineStep.StepType.ROT_END, null);
                        me.actions.add(step);
                        me.steps.add(step);
                        continue;
                    }
                    matcher = parMetaPattern.matcher(line);
                    if (matcher.matches()) {
                        header = false;
                        action = new LDrawLineParMeta(main, lineNr, line, LDrawFiles.getLDrawString(matcher, 1).toUpperCase(), LDrawFiles.getLDrawString(matcher, 2).toUpperCase(), LDrawFiles.getLDrawParOptions(LDrawFiles.getLDrawString(matcher, 3)));
                        me.actions.add(action);
                        continue;
                    }
                    if (header) {
                        me.headers.add(new LDrawLineOther(main, lineNr, line));
                    } else {
                        me.actions.add(new LDrawLineOther(main, lineNr, line));
                    }
                    if (!header) continue;
                    String loli = line.toLowerCase();
                    if (loli.startsWith("0 name: ")) {
                        if (me.givenName != null) continue;
                        me.givenName = line.substring(8).trim();
                        continue;
                    }
                    if (loli.startsWith("0 author: ")) {
                        if (me.author != null) continue;
                        me.author = line.substring(10).trim();
                        continue;
                    }
                    if (loli.startsWith("0 !license ")) {
                        if (me.license != null) continue;
                        me.license = line.substring(11).trim();
                        continue;
                    }
                    if (me.description != null) continue;
                    me.description = line.substring(2).trim();
                    continue;
                }
                header = false;
                switch (line.charAt(0)) {
                    case '1': {
                        matcher = partrefPattern.matcher(line);
                        if (matcher.matches()) {
                            action = new LDrawLinePartRef(main, lineNr, line, LDrawFiles.getLDrawColor(matcher, 1), LDrawFiles.getLDrawMatrix(matcher, 2), LDrawFiles.getLDrawString(matcher, 14));
                            me.actions.add(action);
                            continue block19;
                        }
                        break;
                    }
                    case '2': {
                        matcher = linePattern.matcher(line);
                        if (matcher.matches()) {
                            action = new LDrawLineLine(main, lineNr, line, LDrawFiles.getLDrawColor(matcher, 1), LDrawFiles.getLDrawPoint(matcher, 2), LDrawFiles.getLDrawPoint(matcher, 5));
                            me.actions.add(action);
                            continue block19;
                        }
                        break;
                    }
                    case '3': {
                        matcher = triPattern.matcher(line);
                        if (matcher.matches()) {
                            action = new LDrawLineTri(main, lineNr, line, LDrawFiles.getLDrawColor(matcher, 1), LDrawFiles.getLDrawPoint(matcher, 2), LDrawFiles.getLDrawPoint(matcher, 5), LDrawFiles.getLDrawPoint(matcher, 8));
                            me.actions.add(action);
                            continue block19;
                        }
                        break;
                    }
                    case '4': {
                        matcher = quadPattern.matcher(line);
                        if (matcher.matches()) {
                            action = new LDrawLineQuad(main, lineNr, line, LDrawFiles.getLDrawColor(matcher, 1), LDrawFiles.getLDrawPoint(matcher, 2), LDrawFiles.getLDrawPoint(matcher, 5), LDrawFiles.getLDrawPoint(matcher, 8), LDrawFiles.getLDrawPoint(matcher, 11));
                            me.actions.add(action);
                            continue block19;
                        }
                        break;
                    }
                    case '5': {
                        matcher = auxLinePattern.matcher(line);
                        if (matcher.matches()) {
                            me.actions.add(new LDrawLineOther(main, lineNr, line));
                            continue block19;
                        }
                        break;
                    }
                }
            }
            catch (LDrawConvertException e) {
                if (logger != null) {
                    logger.log("internal exception: " + e.getClass().getName() + ": " + e.getMessage() + " in line " + lineNr + ": " + line);
                }
                e.printStackTrace();
            }
            if (logger == null) continue;
            logger.log("non-matching / failed line " + lineNr + ": " + line);
        }
        if (onlyMainHeader) {
            me.headers = null;
            me.actions = null;
            me.steps = null;
        }
        return main;
    }

    private static int getLDrawColor(Matcher m, int offset) throws LDrawConvertException {
        try {
            String v = m.group(offset);
            if (v.startsWith("0x")) {
                return Integer.parseInt(v, 2, v.length(), 16);
            }
            return Integer.parseInt(v);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new LDrawConvertException(e);
        }
    }

    private static String getLDrawString(Matcher m, int offset) throws LDrawConvertException {
        try {
            return m.group(offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new LDrawConvertException(e);
        }
    }

    private static String[] getLDrawTrimmedStrings(Matcher m, int offset) throws LDrawConvertException {
        try {
            String[] res = m.group(offset).split("\\s");
            return res;
        }
        catch (IndexOutOfBoundsException e) {
            throw new LDrawConvertException(e);
        }
    }

    private static HashMap<String, String> getLDrawParOptions(String opts) throws LDrawConvertException {
        try {
            HashMap<String, String> res = new HashMap<String, String>();
            Matcher m = parMetaOptions.matcher(opts);
            while (m.find()) {
                String key = m.group(1);
                String value = m.group(2);
                res.put(key, value);
            }
            return res;
        }
        catch (IndexOutOfBoundsException e) {
            throw new LDrawConvertException(e);
        }
    }

    private static LDrawPoint getLDrawPoint(Matcher m, int startOffset) throws LDrawConvertException {
        try {
            return new LDrawPoint(Double.parseDouble(m.group(startOffset)), Double.parseDouble(m.group(startOffset + 1)), Double.parseDouble(m.group(startOffset + 2)));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new LDrawConvertException(e);
        }
    }

    private static LDrawMatrix getLDrawMatrix(Matcher m, int startOffset) throws LDrawConvertException {
        try {
            return new LDrawMatrix(Double.parseDouble(m.group(startOffset + 3)), Double.parseDouble(m.group(startOffset + 4)), Double.parseDouble(m.group(startOffset + 5)), Double.parseDouble(m.group(startOffset)), Double.parseDouble(m.group(startOffset + 6)), Double.parseDouble(m.group(startOffset + 7)), Double.parseDouble(m.group(startOffset + 8)), Double.parseDouble(m.group(startOffset + 1)), Double.parseDouble(m.group(startOffset + 9)), Double.parseDouble(m.group(startOffset + 10)), Double.parseDouble(m.group(startOffset + 11)), Double.parseDouble(m.group(startOffset + 2)));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new LDrawConvertException(e);
        }
    }
}

