/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import ldinsp.data.LDIDLooseItem;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIData;
import ldinsp.ext.LDIBricklink;
import ldinsp.ext.LDIEABricklinkInventory;
import ldinsp.ext.LDIEABricklinkItem;
import ldinsp.ext.LDIEAImage;
import ldinsp.ext.LDIEAPart;
import ldinsp.ext.LDIEARebrickableInventory;
import ldinsp.ext.LDIEARebrickablePbg;
import ldinsp.ext.LDIEARebrickableSet;
import ldinsp.ext.LDIEAWeblink;
import ldinsp.ext.LDIExternalAction;
import ldinsp.ext.LDIExternalActionResult;
import ldinsp.ext.LDIExternalActionType;
import ldinsp.ext.LDILDraw;
import ldinsp.ext.LDIRebrickable;
import ldinsp.gui.GuiHelper;
import ldinsp.gui.LDIGui;
import ldinsp.gui.view.LDIVSearch;
import ldinsp.gui.view.LDIView;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDIVWeb
extends VBox
implements LDIView {
    private static final int IMG_PREVIEW_WIDTH = 90;
    private static final int IMG_INTREGR_WITH = 60;
    private final LDIGui main;
    private final ImageView previewImg;
    private final HashMap<LDIExternalActionResult, Image> imageCache;
    private final ComboBox<ImageConfig> imageConfigSel;
    private final TextField key;
    private final TreeItem<LDIExternalActionResult> root;
    private final TreeTableColumn<LDIExternalActionResult, LDIExternalActionResult> imgColumn;
    private final TreeTableView<LDIExternalActionResult> tableView;
    private boolean isTabSelected;
    private ImageConfig imageConfig;
    private LDIDPartList curPartListSourceEditable;
    private TreeItem<LDIData> curPartListSourceItem;

    public LDIVWeb(LDIGui imain) {
        this.main = imain;
        this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.setSpacing(10.0);
        this.root = new TreeItem();
        this.imageCache = new HashMap();
        HBox controlLineComp = new HBox();
        controlLineComp.setSpacing(10.0);
        controlLineComp.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow((Node)controlLineComp, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)controlLineComp);
        this.previewImg = new ImageView();
        this.previewImg.setFitWidth(90.0);
        this.previewImg.setFitHeight(90.0);
        this.previewImg.setPreserveRatio(true);
        StackPane pane = new StackPane(new Node[]{this.previewImg});
        controlLineComp.getChildren().add((Object)pane);
        pane.setAlignment(Pos.CENTER);
        pane.setPrefSize(90.0, 90.0);
        VBox controlLineRight = new VBox();
        controlLineRight.setSpacing(10.0);
        HBox.setHgrow((Node)controlLineRight, (Priority)Priority.ALWAYS);
        controlLineComp.getChildren().add((Object)controlLineRight);
        HBox line = new HBox();
        line.setSpacing(10.0);
        controlLineRight.setAlignment(Pos.CENTER_LEFT);
        controlLineRight.getChildren().add((Object)line);
        Button button = new Button("Clear results");
        button.setTooltip(new Tooltip("Clear result table"));
        button.setOnAction(event -> this.clearResults());
        line.getChildren().add((Object)button);
        line.getChildren().add((Object)new Text("Key"));
        this.key = new TextField();
        this.key.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.key, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.key);
        button = new Button("All");
        button.setDefaultButton(true);
        button.setTooltip(new Tooltip("Search via all available functions"));
        button.setOnAction(event -> this.searchAll(this.root));
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        controlLineRight.getChildren().add((Object)line);
        button = new Button("OMR search");
        button.setTooltip(new Tooltip("Search LDraw Official Model Repository for set"));
        button.setOnAction(event -> this.searchOMR(this.root, this.key.getText()));
        line.getChildren().add((Object)button);
        button = new Button("Ass. BL search");
        button.setTooltip(new Tooltip("Search associatively with Bricklink autocomplete function"));
        button.setOnAction(event -> this.searchBricklink(this.root, false));
        line.getChildren().add((Object)button);
        button = new Button("Full BL product search");
        button.setTooltip(new Tooltip("Search exactly with Bricklink searchproduct function"));
        button.setOnAction(event -> this.searchBricklink(this.root, true));
        line.getChildren().add((Object)button);
        button = new Button("Ass. RB search");
        button.setTooltip(new Tooltip("Search associatively with Rebrickable autocomplete function"));
        button.setOnAction(event -> this.searchRebrickable(this.root, this.key.getText(), false));
        line.getChildren().add((Object)button);
        button = new Button("RB set search");
        button.setTooltip(new Tooltip("Search Rebrickable set for inventory"));
        button.setOnAction(event -> this.searchRebrickable(this.root, this.key.getText(), true));
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        controlLineRight.getChildren().add((Object)line);
        this.imageConfigSel = new ComboBox();
        this.imageConfigSel.getItems().addAll((Object[])ImageConfig.values());
        this.imageConfigSel.getSelectionModel().clearAndSelect(0);
        this.imageConfig = ImageConfig.values()[0];
        this.imageConfigSel.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> this.imageConfigUpdated((ImageConfig)((Object)newVal)));
        this.imageConfigSel.setCellFactory((Callback)new Callback<ListView<ImageConfig>, ListCell<ImageConfig>>(){

            public ListCell<ImageConfig> call(ListView<ImageConfig> p) {
                return new ListCell<ImageConfig>(){

                    protected void updateItem(ImageConfig item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item.text);
                            this.setTooltip(item.tip);
                        } else {
                            this.setText("");
                            this.setGraphic(null);
                            this.setTooltip(null);
                        }
                    }
                };
            }
        });
        line.getChildren().add(this.imageConfigSel);
        button = new Button("Load all images");
        button.setTooltip(new Tooltip("Load all images for visible items in background task"));
        button.setOnAction(event -> this.loadImages(this.root));
        line.getChildren().add((Object)button);
        button = new Button("Resolve ~moved parts");
        button.setTooltip(new Tooltip("Resolve all currently listed parts that are ~moved"));
        button.setOnAction(event -> this.resolveMoved(this.root));
        line.getChildren().add((Object)button);
        button = new Button("Resolve inventories");
        button.setTooltip(new Tooltip("Resolve all currently listed inventories that are not existing as part"));
        button.setOnAction(event -> this.resolveInventories(this.root));
        line.getChildren().add((Object)button);
        TreeTableColumn descColumn = new TreeTableColumn("Description");
        descColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((LDIExternalActionResult)param.getValue().getValue()).description));
        descColumn.setPrefWidth(450.0);
        descColumn.setMinWidth(250.0);
        this.imgColumn = new TreeTableColumn("Img.");
        this.imgColumn.setPrefWidth(65.0);
        this.imgColumn.setMinWidth(5.0);
        this.imgColumn.setVisible(false);
        this.imgColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((LDIExternalActionResult)param.getValue().getValue())));
        this.imgColumn.setCellFactory((Callback)new Callback<TreeTableColumn<LDIExternalActionResult, LDIExternalActionResult>, TreeTableCell<LDIExternalActionResult, LDIExternalActionResult>>(){

            public TreeTableCell<LDIExternalActionResult, LDIExternalActionResult> call(TreeTableColumn<LDIExternalActionResult, LDIExternalActionResult> p) {
                return new TreeTableCell<LDIExternalActionResult, LDIExternalActionResult>(){

                    protected void updateItem(LDIExternalActionResult item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null || !(this).LDIVWeb.this.imgColumn.isVisible()) {
                            this.setGraphic(null);
                            return;
                        }
                        Image img = (this).LDIVWeb.this.imageCache.get(item);
                        if (img != null) {
                            ImageView iv = new ImageView();
                            iv.setFitWidth(60.0);
                            iv.setFitHeight(60.0);
                            iv.setPreserveRatio(true);
                            iv.setImage(img);
                            this.setGraphic((Node)iv);
                            return;
                        }
                        LDIEAImage ea = (LDIEAImage)LDIVWeb.this.getFirstAction(item, LDIExternalActionType.URL_IMAGE);
                        if (ea == null) {
                            this.setGraphic(null);
                            return;
                        }
                    }
                };
            }
        });
        TreeTableColumn actionsColumn = new TreeTableColumn("Actions");
        actionsColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((LDIExternalActionResult)param.getValue().getValue())));
        actionsColumn.setCellFactory((Callback)new Callback<TreeTableColumn<LDIExternalActionResult, LDIExternalActionResult>, TreeTableCell<LDIExternalActionResult, LDIExternalActionResult>>(){

            public TreeTableCell<LDIExternalActionResult, LDIExternalActionResult> call(final TreeTableColumn<LDIExternalActionResult, LDIExternalActionResult> p) {
                return new TreeTableCell<LDIExternalActionResult, LDIExternalActionResult>(){

                    protected void updateItem(LDIExternalActionResult item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null || empty) {
                            this.setGraphic(null);
                            return;
                        }
                        TreeTableView treeTable = p.getTreeTableView();
                        TreeItem treeItem = treeTable.getTreeItem(this.getIndex());
                        LDIExternalActionResult ear = item;
                        HBox box = new HBox();
                        Button but = new Button("X");
                        but.setTooltip(new Tooltip("Remove item"));
                        but.setOnAction(event -> {
                            boolean bl = treeItem.getParent().getChildren().remove((Object)treeItem);
                        });
                        box.getChildren().add((Object)but);
                        for (LDIExternalAction a : ear.actions) {
                            switch (a.getType()) {
                                case URL_IMAGE: {
                                    LDIEAImage eaui = (LDIEAImage)a;
                                    but = new Button("Img.");
                                    but.setTooltip(new Tooltip("Load image"));
                                    but.setOnAction(event -> LDIVWeb.this.showRemoteImage(item, lDIEAImage.url, false));
                                    box.getChildren().add((Object)but);
                                    break;
                                }
                                case URL_WEB: {
                                    LDIEAWeblink eawl = (LDIEAWeblink)a;
                                    but = new Button("WWW");
                                    but.setTooltip(new Tooltip("Open browser"));
                                    but.setOnAction(event -> (this).LDIVWeb.this.main.services.showDocument(lDIEAWeblink.url));
                                    box.getChildren().add((Object)but);
                                    break;
                                }
                                case PART: {
                                    LDrawPartOrigin o;
                                    LDIEAPart eap = (LDIEAPart)a;
                                    but = new Button("S");
                                    but.setTooltip(new Tooltip("Search for part with given description"));
                                    but.setOnAction(event -> LDIVWeb.this.searchPartDescription((TreeItem<LDIExternalActionResult>)treeItem, ear, eap));
                                    box.getChildren().add((Object)but);
                                    LDrawPart part = (this).LDIVWeb.this.main.ctx.getPart(null, eap.part, null);
                                    if (part == null) {
                                        o = LDrawPartOrigin.MISSING;
                                    } else {
                                        LDrawPart movedPart;
                                        o = part.origin;
                                        if ((treeItem.isLeaf() || treeItem.getChildren().size() == 0) && (movedPart = LDIVWeb.this.getMovedPart(part)) != null) {
                                            but = new Button("M");
                                            but.setTooltip(new Tooltip("This part is ~moved, replace with destination"));
                                            but.setOnAction(event -> LDIVWeb.this.addReplacementPart((TreeItem<LDIExternalActionResult>)treeItem, ear, eap, movedPart));
                                            box.getChildren().add((Object)but);
                                        }
                                    }
                                    but = new Button("+WS");
                                    Circle ci = new Circle(8.0, (Paint)GuiHelper.rgbaToColor(o.rgbaCol));
                                    but.setGraphic((Node)ci);
                                    but.setTooltip(new Tooltip("Add this part to workspace"));
                                    but.setOnAction(event -> LDIVWeb.this.addPart(lDIEAPart.part, lDIEAPart.colId, lDIEAPart.amount, true));
                                    box.getChildren().add((Object)but);
                                    if ((this).LDIVWeb.this.curPartListSourceEditable == null) break;
                                    but = new Button("+LI");
                                    but.setTooltip(new Tooltip("Add this part to the selected part list"));
                                    but.setOnAction(event -> LDIVWeb.this.addPart(lDIEAPart.part, lDIEAPart.colId, lDIEAPart.amount, false));
                                    box.getChildren().add((Object)but);
                                    break;
                                }
                                case BL_ITEM: {
                                    LDIEABricklinkItem eabit = (LDIEABricklinkItem)a;
                                    but = new Button("Product");
                                    but.setTooltip(new Tooltip("Get information about this product"));
                                    but.setOnAction(event -> LDIVWeb.this.loadBricklinkProduct((TreeItem<LDIExternalActionResult>)treeItem, lDIEABricklinkItem.item));
                                    box.getChildren().add((Object)but);
                                    break;
                                }
                                case BL_INVENTORY: {
                                    LDIEABricklinkInventory eabin = (LDIEABricklinkInventory)a;
                                    if (treeItem.isLeaf() || treeItem.getChildren().size() == 0) {
                                        but = new Button("Inv.Reg.");
                                        but.setTooltip(new Tooltip("Load regular sub-items of this inventory"));
                                        but.setOnAction(event -> LDIVWeb.this.loadBricklinkInventory((TreeItem<LDIExternalActionResult>)treeItem, lDIEABricklinkInventory.inventory, true));
                                        box.getChildren().add((Object)but);
                                        but = new Button("Inv.All");
                                        but.setTooltip(new Tooltip("Load all sub-items including extra/alternate/counterparts, may contain duplicates"));
                                        but.setOnAction(event -> LDIVWeb.this.loadBricklinkInventory((TreeItem<LDIExternalActionResult>)treeItem, lDIEABricklinkInventory.inventory, false));
                                        box.getChildren().add((Object)but);
                                        break;
                                    }
                                    but = new Button("Un.Inv.");
                                    but.setTooltip(new Tooltip("Remove all sub-items of this inventory"));
                                    but.setOnAction(event -> {
                                        treeItem.getChildren().clear();
                                        (this).LDIVWeb.this.tableView.refresh();
                                    });
                                    box.getChildren().add((Object)but);
                                    but = new Button("C.List");
                                    but.setTooltip(new Tooltip("Create new part list containing all parts of this item"));
                                    but.setOnAction(event -> LDIVWeb.this.addAllParts((TreeItem<LDIExternalActionResult>)treeItem, 1, null));
                                    box.getChildren().add((Object)but);
                                    if ((this).LDIVWeb.this.curPartListSourceEditable == null) break;
                                    but = new Button("+SLI");
                                    but.setTooltip(new Tooltip("Add sub-items to the selected part list"));
                                    but.setOnAction(event -> LDIVWeb.this.addAllParts((TreeItem<LDIExternalActionResult>)treeItem, 1, (this).LDIVWeb.this.curPartListSourceEditable));
                                    box.getChildren().add((Object)but);
                                    break;
                                }
                                case RB_PBG: {
                                    LDIEARebrickablePbg earp = (LDIEARebrickablePbg)a;
                                    but = new Button("PBG");
                                    but.setTooltip(new Tooltip("Load PBG and save to file"));
                                    but.setOnAction(event -> LDIVWeb.this.saveRebrickablePbg(LDIVWeb.sanitize(lDIExternalActionResult.description), lDIEARebrickablePbg.url));
                                    box.getChildren().add((Object)but);
                                    break;
                                }
                                case RB_SET: {
                                    LDIEARebrickableSet ears = (LDIEARebrickableSet)a;
                                    but = new Button("Set");
                                    but.setTooltip(new Tooltip("Get information about this set"));
                                    but.setOnAction(event -> LDIVWeb.this.searchRebrickable((TreeItem<LDIExternalActionResult>)treeItem, lDIEARebrickableSet.set, true));
                                    box.getChildren().add((Object)but);
                                    break;
                                }
                                case RB_INVENTORY: {
                                    LDIEARebrickableInventory eari = (LDIEARebrickableInventory)a;
                                    if (treeItem.isLeaf() || treeItem.getChildren().size() == 0) {
                                        but = new Button("Inventory");
                                        but.setTooltip(new Tooltip("Load sub-items of this inventory"));
                                        but.setOnAction(event -> LDIVWeb.this.loadRebrickableInventory((TreeItem<LDIExternalActionResult>)treeItem, lDIEARebrickableInventory.inventory));
                                        box.getChildren().add((Object)but);
                                        break;
                                    }
                                    but = new Button("Un.Inv.");
                                    but.setTooltip(new Tooltip("Remove all sub-items of this inventory"));
                                    but.setOnAction(event -> {
                                        treeItem.getChildren().clear();
                                        (this).LDIVWeb.this.tableView.refresh();
                                    });
                                    box.getChildren().add((Object)but);
                                    but = new Button("C.List");
                                    but.setTooltip(new Tooltip("Create new part list containing all parts of this item"));
                                    but.setOnAction(event -> LDIVWeb.this.addAllParts((TreeItem<LDIExternalActionResult>)treeItem, 1, null));
                                    box.getChildren().add((Object)but);
                                    if ((this).LDIVWeb.this.curPartListSourceEditable == null) break;
                                    but = new Button("+SLI");
                                    but.setTooltip(new Tooltip("Add sub-items to the selected part list"));
                                    but.setOnAction(event -> LDIVWeb.this.addAllParts((TreeItem<LDIExternalActionResult>)treeItem, 1, (this).LDIVWeb.this.curPartListSourceEditable));
                                    box.getChildren().add((Object)but);
                                }
                            }
                        }
                        this.setGraphic((Node)box);
                    }
                };
            }
        });
        actionsColumn.setSortable(false);
        actionsColumn.setPrefWidth(400.0);
        actionsColumn.setMinWidth(100.0);
        this.tableView = new TreeTableView(this.root);
        this.tableView.setShowRoot(false);
        this.tableView.setManaged(true);
        this.tableView.setEditable(true);
        this.tableView.setPlaceholder((Node)new Text("No result"));
        this.tableView.getColumns().add((Object)descColumn);
        this.tableView.getColumns().add(this.imgColumn);
        this.tableView.getColumns().add((Object)actionsColumn);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.getSelectionModel().setCellSelectionEnabled(false);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((obs, oldSel, newSel) -> this.selUpdated((TreeItem<LDIExternalActionResult>)newSel));
        VBox.setVgrow(this.tableView, (Priority)Priority.ALWAYS);
        this.getChildren().add(this.tableView);
    }

    @Override
    public void contextChanged() {
    }

    @Override
    public void invalidateItem(TreeItem<LDIData> invalid) {
        if (this.curPartListSourceItem == null || this.curPartListSourceItem != invalid) {
            return;
        }
        if (this.isTabSelected) {
            this.tableView.refresh();
        }
    }

    @Override
    public void onTabSelection(boolean state) {
        if (!this.isTabSelected && state) {
            this.tableView.refresh();
        }
        this.isTabSelected = state;
    }

    @Override
    public void selUpdated(ObservableValue<? extends TreeItem<LDIData>> obs, TreeItem<LDIData> oldSel, TreeItem<LDIData> newSel, boolean active) {
        if (newSel == null) {
            this.curPartListSourceItem = null;
            this.curPartListSourceEditable = null;
        } else {
            this.curPartListSourceEditable = this.main.getAsUnfixedPartList(newSel);
            Object object = this.curPartListSourceItem = this.curPartListSourceEditable != null ? newSel : null;
        }
        if (this.isTabSelected) {
            this.tableView.refresh();
        }
    }

    private void imageConfigUpdated(ImageConfig newVal) {
        this.imageConfig = newVal;
        this.imgColumn.setVisible(newVal == ImageConfig.INTEGRATED);
        if (this.isTabSelected) {
            this.tableView.refresh();
        }
    }

    private void selUpdated(TreeItem<LDIExternalActionResult> newSel) {
        if (newSel == null) {
            this.previewImg.setImage(null);
            return;
        }
        LDIExternalActionResult ear = (LDIExternalActionResult)newSel.getValue();
        Image img = this.imageCache.get(ear);
        if (img != null) {
            this.previewImg.setImage(img);
            return;
        }
        LDIEAImage ea = (LDIEAImage)this.getFirstAction(ear, LDIExternalActionType.URL_IMAGE);
        if (ea == null) {
            this.previewImg.setImage(null);
            return;
        }
        this.showRemoteImage(ear, ea.url, this.imageConfig == ImageConfig.MANUAL);
    }

    private LDIExternalAction getFirstAction(TreeItem<LDIExternalActionResult> item, LDIExternalActionType type) {
        if (item == null) {
            return null;
        }
        return this.getFirstAction((LDIExternalActionResult)item.getValue(), type);
    }

    private LDIExternalAction getFirstAction(LDIExternalActionResult ear, LDIExternalActionType type) {
        if (ear != null && ear.actions != null) {
            for (LDIExternalAction a : ear.actions) {
                if (a.getType() != type) continue;
                return a;
            }
        }
        return null;
    }

    private void clearResults() {
        this.root.getChildren().clear();
        this.imageCache.clear();
        this.previewImg.setImage(null);
        this.tableView.refresh();
    }

    private void insertResult(TreeItem<LDIExternalActionResult> parent, List<LDIExternalActionResult> result) {
        if (result != null) {
            Platform.runLater(() -> {
                for (LDIExternalActionResult ea : result) {
                    parent.getChildren().add((Object)new TreeItem((Object)ea));
                }
                parent.setExpanded(true);
                this.tableView.refresh();
            });
        }
    }

    private void searchAll(final TreeItem<LDIExternalActionResult> parent) {
        final String search = this.key.getText();
        if (search.length() == 0) {
            return;
        }
        this.main.runAndWait("Performing all search methods...", new Task<Void>(){

            protected Void call() {
                String setSearch = search.indexOf(45) != -1 ? LDIVWeb.this.key.getText() : String.valueOf(LDIVWeb.this.key.getText()) + "-1";
                LDIVWeb.this.insertResult((TreeItem<LDIExternalActionResult>)parent, LDILDraw.searchOMR(search, LDIVWeb.this.main.ctx, LDIVWeb.this.main));
                LDIVWeb.this.insertResult((TreeItem<LDIExternalActionResult>)parent, LDIBricklink.quickSearch(search, LDIVWeb.this.main.ctx, LDIVWeb.this.main));
                LDIVWeb.this.insertResult((TreeItem<LDIExternalActionResult>)parent, LDIBricklink.fullSearch(search, LDIVWeb.this.main.ctx, LDIVWeb.this.main));
                LDIVWeb.this.insertResult((TreeItem<LDIExternalActionResult>)parent, LDIRebrickable.quickSearch(search, LDIVWeb.this.main.ctx, LDIVWeb.this.main));
                LDIVWeb.this.insertResult((TreeItem<LDIExternalActionResult>)parent, LDIRebrickable.searchSet(setSearch, LDIVWeb.this.main.ctx, LDIVWeb.this.main));
                return null;
            }
        });
    }

    private void searchOMR(final TreeItem<LDIExternalActionResult> parent, final String search) {
        if (search.length() == 0) {
            return;
        }
        this.main.runAndWait("Performing OMR search...", new Task<Void>(){

            protected Void call() {
                LDIVWeb.this.insertResult((TreeItem<LDIExternalActionResult>)parent, LDILDraw.searchOMR(search, LDIVWeb.this.main.ctx, LDIVWeb.this.main));
                return null;
            }
        });
    }

    private void searchBricklink(final TreeItem<LDIExternalActionResult> parent, final boolean full) {
        String search = this.key.getText();
        if (search.length() == 0) {
            return;
        }
        this.main.runAndWait("Performing Bricklink search...", new Task<Void>(){

            protected Void call() {
                LDIVWeb.this.insertResult((TreeItem<LDIExternalActionResult>)parent, full ? LDIBricklink.fullSearch(LDIVWeb.this.key.getText(), LDIVWeb.this.main.ctx, LDIVWeb.this.main) : LDIBricklink.quickSearch(LDIVWeb.this.key.getText(), LDIVWeb.this.main.ctx, LDIVWeb.this.main));
                return null;
            }
        });
    }

    private void showRemoteImage(LDIExternalActionResult forEar, String url, boolean onlyCached) {
        try {
            String cacheName = "urlimg_" + LDIVWeb.sanitize(url);
            InputStream is = onlyCached ? this.main.ctx.loadCachedResource(cacheName) : this.main.ctx.loadCachedWebResource(cacheName, url, this.main);
            if (is == null) {
                this.previewImg.setImage(null);
            } else {
                Image img = new Image(is, 90.0, 90.0, true, true);
                is.close();
                this.imageCache.put(forEar, img);
                this.previewImg.setImage(img);
                if (this.imageConfig == ImageConfig.INTEGRATED) {
                    this.tableView.refresh();
                }
            }
        }
        catch (IOException e) {
            this.main.log("Show remote image exception: " + e.getClass().getName() + ": " + e.getMessage());
            this.previewImg.setImage(null);
        }
    }

    private void loadBricklinkProduct(final TreeItem<LDIExternalActionResult> parent, final int id) {
        this.main.runAndWait("Requesting Bricklink catalog item...", new Task<Void>(){

            protected Void call() {
                LDIVWeb.this.insertResult((TreeItem<LDIExternalActionResult>)parent, LDIBricklink.getCatalogItem(id, LDIVWeb.this.main.ctx, LDIVWeb.this.main));
                return null;
            }
        });
    }

    private void loadBricklinkInventory(final TreeItem<LDIExternalActionResult> parent, final String item, final boolean onlyRegular) {
        this.main.runAndWait("Requesting Bricklink inventory...", new Task<Void>(){

            protected Void call() {
                LDIVWeb.this.insertResult((TreeItem<LDIExternalActionResult>)parent, LDIBricklink.getInventory(item, onlyRegular, LDIVWeb.this.main.ctx, LDIVWeb.this.main));
                return null;
            }
        });
    }

    private LDrawPart getMovedPart(LDrawPart part) {
        LDrawPart mp = this.main.ctx.getMoveCleanedPart(part);
        if (mp != null && mp != part && mp.loadedFromFilename != null) {
            return mp;
        }
        return null;
    }

    private void searchPartDescription(final TreeItem<LDIExternalActionResult> item, final LDIExternalActionResult ear, final LDIEAPart ap) {
        final LDIVSearch searchDialogPane = new LDIVSearch(this.main);
        searchDialogPane.initDialogPartSearch(ap.part.substring(0, ap.part.length() - 4), ap.desc, ap.colId, ap.amount);
        this.main.runAndWait("Performing search...", new Task<Void>(){

            protected Void call() throws Exception {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Dialog cd = new Dialog();
                        cd.getDialogPane().setContent((Node)searchDialogPane);
                        cd.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
                        cd.setResultConverter(bt -> {
                            if (bt != null && bt.getButtonData() == ButtonBar.ButtonData.OK_DONE) {
                                return searchDialogPane.getSelectedPart();
                            }
                            return null;
                        });
                        cd.showAndWait().ifPresent(np -> LDIVWeb.this.addReplacementPart((TreeItem<LDIExternalActionResult>)item, ear, ap, (LDrawPart)np));
                        GuiHelper.fixPrimaryStage();
                    }
                });
                return null;
            }
        });
    }

    private void addReplacementPart(TreeItem<LDIExternalActionResult> item, LDIExternalActionResult ear, LDIEAPart ap, LDrawPart np) {
        LDIExternalActionResult near = new LDIExternalActionResult("[R] " + np.loadedFromFilename.substring(0, np.loadedFromFilename.length() - 4) + " " + np.description);
        near.actions.add(new LDIEAPart(np.loadedFromFilename, np.description, ap.colId, 1));
        item.getChildren().add((Object)new TreeItem((Object)near));
        item.setExpanded(true);
        this.tableView.refresh();
    }

    private void addPart(String name, int colId, int amount, boolean workspace) {
        if (workspace) {
            this.main.addDataItem(new LDIDLooseItem(name, colId, amount));
        } else if (this.curPartListSourceEditable != null) {
            this.curPartListSourceEditable.addPart(name, colId, amount, LDrawPartOrigin.UNRESOLVED, false);
            this.main.rebuildItem(this.curPartListSourceItem);
        }
    }

    private int searchParentColor(TreeItem<LDIExternalActionResult> item) {
        while ((item = item.getParent()) != null) {
            LDIEAPart ap = (LDIEAPart)this.getFirstAction((TreeItem<LDIExternalActionResult>)item, LDIExternalActionType.PART);
            if (ap == null || ap.colId == 16) continue;
            return ap.colId;
        }
        return 16;
    }

    private void addAllParts(TreeItem<LDIExternalActionResult> parent, int multiply, LDIDPartList res) {
        boolean isTop = false;
        if (res == null) {
            isTop = true;
            res = new LDIDPartList("PL " + ((LDIExternalActionResult)parent.getValue()).description);
        }
        for (TreeItem item : parent.getChildren()) {
            LDIEAPart ap = (LDIEAPart)this.getFirstAction((TreeItem<LDIExternalActionResult>)item, LDIExternalActionType.PART);
            if (ap == null) {
                if (item.isLeaf() || item.getChildren().size() == 0) continue;
                this.addAllParts((TreeItem<LDIExternalActionResult>)item, multiply, res);
                continue;
            }
            int colId = ap.colId;
            if (colId == 16) {
                colId = this.searchParentColor((TreeItem<LDIExternalActionResult>)item);
            }
            int amount = multiply * ap.amount;
            if (item.isLeaf() || item.getChildren().size() == 0) {
                res.addPart(ap.part, colId, amount, LDrawPartOrigin.UNRESOLVED, false);
                continue;
            }
            this.addAllParts((TreeItem<LDIExternalActionResult>)item, amount, res);
        }
        if (isTop) {
            this.main.addDataItem(res);
        } else if (res == this.curPartListSourceEditable) {
            this.main.rebuildItem(this.curPartListSourceItem);
        }
    }

    private void searchRebrickable(final TreeItem<LDIExternalActionResult> parent, final String search, final boolean exact) {
        if (search.length() == 0) {
            return;
        }
        final String set = search.indexOf(45) != -1 ? search : String.valueOf(search) + "-1";
        this.main.runAndWait("Performing Rebrickable set search...", new Task<Void>(){

            protected Void call() {
                LDIVWeb.this.insertResult((TreeItem<LDIExternalActionResult>)parent, exact ? LDIRebrickable.searchSet(set, LDIVWeb.this.main.ctx, LDIVWeb.this.main) : LDIRebrickable.quickSearch(search, LDIVWeb.this.main.ctx, LDIVWeb.this.main));
                return null;
            }
        });
    }

    private void saveRebrickablePbg(String name, final String url) {
        final File f = GuiHelper.showFileSaveDialog("Save Rebrickable PBG", String.valueOf(name) + ".pbg", true);
        if (f == null) {
            return;
        }
        this.main.runAndWait("Downloading Rebrickable PBG...", new Task<Void>(){

            protected Void call() {
                try {
                    LDIVWeb.this.main.ctx.saveWebResource(f, url);
                }
                catch (IOException e) {
                    GuiHelper.alert(Alert.AlertType.ERROR, "LDInspector: save PBG failed", "Writing PBG failed, because there was an I/O error", String.valueOf(e.getClass().getName()) + ": " + e.getMessage(), true);
                    return null;
                }
                return null;
            }
        });
    }

    private void loadRebrickableInventory(final TreeItem<LDIExternalActionResult> parent, final String inv) {
        this.main.runAndWait("Requesting Rebrickable inventory...", new Task<Void>(){

            protected Void call() {
                LDIVWeb.this.insertResult((TreeItem<LDIExternalActionResult>)parent, LDIRebrickable.getInventory(inv, LDIVWeb.this.main.ctx, LDIVWeb.this.main));
                return null;
            }
        });
    }

    private static String sanitize(String url) {
        return url.replaceAll("[\\[\\]\\{\\}\\(\\)\\\\\\\\.:;#?&/<>|*\u00b4`\"']", "");
    }

    private void loadImages(final TreeItem<LDIExternalActionResult> parent) {
        this.tableView.getSelectionModel().clearSelection();
        this.main.runAndWait("Loading images...", new Task<Void>(){

            protected Void call() throws Exception {
                LDIVWeb.this.doLoadImages((TreeItem<LDIExternalActionResult>)parent);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        (this).LDIVWeb.this.tableView.refresh();
                    }
                });
                return null;
            }
        });
    }

    private void doLoadImages(TreeItem<LDIExternalActionResult> parent) {
        for (TreeItem item : parent.getChildren()) {
            LDIEAImage ea;
            LDIExternalActionResult ear = (LDIExternalActionResult)item.getValue();
            Image img = this.imageCache.get(ear);
            if (img == null && (ea = (LDIEAImage)this.getFirstAction(ear, LDIExternalActionType.URL_IMAGE)) != null) {
                try {
                    String cacheName = "urlimg_" + LDIVWeb.sanitize(ea.url);
                    InputStream is = this.main.ctx.loadCachedWebResource(cacheName, ea.url, this.main);
                    if (is != null) {
                        img = new Image(is, 90.0, 90.0, true, true);
                        is.close();
                        this.imageCache.put(ear, img);
                    }
                }
                catch (IOException e) {
                    this.main.log("Show remote image exception: " + e.getClass().getName() + ": " + e.getMessage());
                }
            }
            if (item.isLeaf() || item.getChildren().size() <= 0) continue;
            this.loadImages((TreeItem<LDIExternalActionResult>)item);
        }
    }

    private void resolveMoved(TreeItem<LDIExternalActionResult> parent) {
        for (TreeItem item : parent.getChildren()) {
            if (item.isLeaf() || item.getChildren().size() == 0) {
                LDIExternalActionResult ear = (LDIExternalActionResult)item.getValue();
                for (LDIExternalAction a : ear.actions) {
                    LDrawPart movedPart;
                    if (a.getType() != LDIExternalActionType.PART) continue;
                    LDIEAPart eap = (LDIEAPart)a;
                    LDrawPart part = this.main.ctx.getPart(null, eap.part, null);
                    if (part == null || (movedPart = this.getMovedPart(part)) == null) continue;
                    this.addReplacementPart((TreeItem<LDIExternalActionResult>)item, ear, eap, movedPart);
                }
                continue;
            }
            this.resolveMoved((TreeItem<LDIExternalActionResult>)item);
        }
    }

    private void resolveInventories(TreeItem<LDIExternalActionResult> parent) {
        for (TreeItem item : parent.getChildren()) {
            if (item.isLeaf() || item.getChildren().size() == 0) {
                LDIExternalActionResult ear = (LDIExternalActionResult)item.getValue();
                for (LDIExternalAction a : ear.actions) {
                    switch (a.getType()) {
                        default: {
                            break;
                        }
                        case BL_INVENTORY: {
                            LDIEABricklinkInventory eabin = (LDIEABricklinkInventory)a;
                            this.loadBricklinkInventory((TreeItem<LDIExternalActionResult>)item, eabin.inventory, true);
                            break;
                        }
                        case RB_INVENTORY: {
                            LDIEARebrickableInventory eari = (LDIEARebrickableInventory)a;
                            this.loadRebrickableInventory((TreeItem<LDIExternalActionResult>)item, eari.inventory);
                        }
                    }
                }
                continue;
            }
            this.resolveInventories((TreeItem<LDIExternalActionResult>)item);
        }
    }

    private static enum ImageConfig {
        MANUAL("Img.: manual", "load images only on manual request"),
        AUTOMATIC("Img.: automatic", "load images automatically on selection if available"),
        INTEGRATED("Img.: integrated", "integrate available images in the list");

        public final String text;
        public final Tooltip tip;

        private ImageConfig(String itext, String ihint) {
            this.text = itext;
            this.tip = new Tooltip(ihint);
        }

        public String toString() {
            return this.text;
        }
    }
}

