/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TreeItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import ldinsp.base.LDILogger;
import ldinsp.data.LDIData;
import ldinsp.gui.view.LDIView;

public class LDIVText
extends BorderPane
implements LDIView,
LDILogger {
    private final HBox controlLine = new HBox();
    private final Button clear;
    private final CheckBox autoscroll;
    private final TextArea ta;

    public LDIVText() {
        this.controlLine.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.controlLine.setSpacing(10.0);
        this.controlLine.setAlignment(Pos.CENTER_LEFT);
        this.setTop((Node)this.controlLine);
        this.clear = new Button("Clear");
        this.clear.setOnAction(event -> this.clear());
        this.clear.setMaxHeight(Double.MAX_VALUE);
        this.controlLine.getChildren().add((Object)this.clear);
        Button button = new Button("Copy to Clipboard");
        button.setOnAction(event -> this.copyToClipboard());
        button.setMaxHeight(Double.MAX_VALUE);
        this.controlLine.getChildren().add((Object)button);
        this.autoscroll = new CheckBox("Autoscroll");
        this.autoscroll.setAllowIndeterminate(false);
        this.autoscroll.setSelected(true);
        this.autoscroll.setMaxHeight(Double.MAX_VALUE);
        this.controlLine.getChildren().add((Object)this.autoscroll);
        this.ta = new TextArea();
        this.ta.setManaged(true);
        this.ta.setEditable(false);
        this.setCenter((Node)this.ta);
    }

    @Override
    public void contextChanged() {
    }

    @Override
    public void invalidateItem(TreeItem<LDIData> invalid) {
    }

    @Override
    public void onTabSelection(boolean state) {
    }

    @Override
    public void selUpdated(ObservableValue<? extends TreeItem<LDIData>> obs, TreeItem<LDIData> oldSel, TreeItem<LDIData> newSel, boolean active) {
    }

    @Override
    public void log(String text) {
        this.append(String.valueOf(text) + "\n");
    }

    public void append(String text) {
        if (Platform.isFxApplicationThread()) {
            this.doAppend(text);
        } else {
            Platform.runLater(() -> this.doAppend(text));
        }
    }

    public void setText(String text) {
        this.ta.setText(text);
    }

    public void addControl(Node e) {
        this.controlLine.getChildren().add((Object)e);
    }

    public void setClearDisable(boolean state) {
        this.clear.setDisable(state);
    }

    public void setAutoscroll(boolean state) {
        this.autoscroll.setSelected(state);
    }

    public void setFont(Font f) {
        this.ta.setFont(f);
    }

    public void clear() {
        this.ta.clear();
    }

    public void setEditable(boolean editable) {
        this.ta.setEditable(editable);
    }

    private void doAppend(String text) {
        if (this.autoscroll.isSelected()) {
            this.ta.appendText(text);
        } else {
            int caretPosition = this.ta.caretPositionProperty().get();
            double scrollTop = this.ta.getScrollTop();
            this.ta.setText(String.valueOf(this.ta.getText()) + text);
            this.ta.positionCaret(caretPosition);
            this.ta.setScrollTop(scrollTop);
        }
    }

    private void copyToClipboard() {
        ClipboardContent content = new ClipboardContent();
        content.putString(this.ta.getText());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }
}

