/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import javafx.util.StringConverter;
import ldinsp.context.LDICColor;
import ldinsp.context.LDICColorHint;
import ldinsp.data.LDIDLooseItem;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIData;
import ldinsp.gui.GuiHelper;
import ldinsp.gui.LDIGui;
import ldinsp.gui.view.LDIPartRender;
import ldinsp.gui.view.LDIPartScene;
import ldinsp.gui.view.LDIPartSceneSettings;
import ldinsp.gui.view.LDIView;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;
import ldinsp.util.StringNumberComparator;

public class LDIVSearch
extends BorderPane
implements LDIView {
    private static final double BUTTON_OBJ_ANGLE_STEP = 15.0;
    private static final int IMG_WIDTH = 90;
    private final LDIGui main;
    private final ObservableList<LDrawPart> entries;
    private final FilteredList<LDrawPart> filteredEntries;
    private final TableColumn<LDrawPart, Number> rankColumn;
    private final TableView<LDrawPart> tableView;
    private final LDIPartSceneSettings previewSet;
    private final LDIPartScene previewPart;
    private final ComboBox<LDICColor> colorSelect;
    private final TextField amount;
    private final Button amountAddList;
    private final Button amountAddWorkspace;
    private final TextField filtFilename;
    private final TextField filtDescription;
    private final TextField filtAuthor;
    private final ComboBox<LDIVSOriginFilter> filtOrigin;
    private final ComboBox<LDIVSWordFilter> filtWord;
    private final Text statistics;
    private final HashMap<LDrawPart, Integer> rankMap;
    private boolean asDialog;
    private TreeItem<LDIData> curMainSelect;
    private LDIDPartList curPartList;
    private LDrawPart curTableSelect;
    private boolean isTabSelected;
    private boolean contextValid;
    private boolean previewValid;

    public LDIVSearch(LDIGui imain) {
        this.main = imain;
        VBox controlPane = new VBox();
        controlPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        controlPane.setSpacing(10.0);
        controlPane.setMinSize(200.0, 100.0);
        this.setTop((Node)controlPane);
        HBox controlLinePane = new HBox();
        controlLinePane.setSpacing(10.0);
        controlLinePane.setAlignment(Pos.CENTER_LEFT);
        controlPane.getChildren().add((Object)controlLinePane);
        this.previewSet = new LDIPartSceneSettings();
        this.previewPart = new LDIPartScene(90, 90, this.previewSet);
        this.previewPart.axesGroup.setVisible(false);
        this.previewPart.objectScene.setFill((Paint)Color.WHITE);
        controlLinePane.getChildren().add((Object)this.previewPart.objectScene);
        VBox controlLineRight = new VBox();
        controlLineRight.setSpacing(10.0);
        controlLinePane.getChildren().add((Object)controlLineRight);
        HBox controlLine = new HBox();
        controlLine.setSpacing(10.0);
        controlLineRight.getChildren().add((Object)controlLine);
        Button button = new Button("Reset View");
        button.setOnAction(event -> {
            this.previewSet.resetView();
            this.previewPart.autoAdjustView();
        });
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("x+");
        button.setOnAction(event -> this.previewSet.objAngleX.set(this.previewSet.objAngleX.get() + 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("x-");
        button.setOnAction(event -> this.previewSet.objAngleX.set(this.previewSet.objAngleX.get() - 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("y+");
        button.setOnAction(event -> this.previewSet.objAngleY.set(this.previewSet.objAngleY.get() + 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("y-");
        button.setOnAction(event -> this.previewSet.objAngleY.set(this.previewSet.objAngleY.get() - 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("z+");
        button.setOnAction(event -> this.previewSet.objAngleZ.set(this.previewSet.objAngleZ.get() + 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("z-");
        button.setOnAction(event -> this.previewSet.objAngleZ.set(this.previewSet.objAngleZ.get() - 15.0));
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        controlLine = new HBox();
        controlLine.setSpacing(10.0);
        controlLineRight.getChildren().add((Object)controlLine);
        this.colorSelect = new ComboBox();
        this.colorSelect.setMaxHeight(Double.MAX_VALUE);
        HBox.setHgrow(this.colorSelect, (Priority)Priority.ALWAYS);
        this.colorSelect.setConverter((StringConverter)new StringConverter<LDICColor>(){

            public String toString(LDICColor c) {
                return c != null ? String.valueOf(Integer.toString(c.id)) + " " + c.name : "";
            }

            public LDICColor fromString(String string) {
                return null;
            }
        });
        this.colorSelect.setCellFactory((Callback)new Callback<ListView<LDICColor>, ListCell<LDICColor>>(){

            public ListCell<LDICColor> call(ListView<LDICColor> p) {
                return new ListCell<LDICColor>(){
                    private final Circle colPreview = new Circle(8.0, (Paint)Color.WHITE);

                    protected void updateItem(LDICColor item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.colPreview.setFill((Paint)GuiHelper.rgbaToColor(item.rgbaFace));
                            this.setGraphic((Node)this.colPreview);
                            this.setText(String.valueOf(Integer.toString(item.id)) + " " + item.name);
                            this.setTooltip(item.hints != null ? new Tooltip(LDICColorHint.hintsToString(item.hints)) : null);
                        } else {
                            this.setText("");
                            this.setGraphic(null);
                            this.setTooltip(null);
                        }
                    }
                };
            }
        });
        this.colorSelect.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            this.previewValid = false;
            if (this.isTabSelected) {
                this.refreshPreview();
            }
        });
        controlLine.getChildren().add(this.colorSelect);
        controlLine = new HBox();
        controlLine.setSpacing(10.0);
        controlLineRight.getChildren().add((Object)controlLine);
        controlLine.getChildren().add((Object)new Text("Amount"));
        this.amount = new TextField();
        this.amount.setPrefWidth(100.0);
        controlLine.getChildren().add((Object)this.amount);
        this.amountAddList = new Button("Add to list");
        this.amountAddList.setOnAction(event -> this.addCurrentItemToPartList());
        this.amountAddList.setMaxHeight(Double.MAX_VALUE);
        this.amountAddList.setTooltip(new Tooltip("Add current selection to current part list with given amount"));
        this.amountAddList.setDisable(true);
        controlLine.getChildren().add((Object)this.amountAddList);
        this.amountAddWorkspace = new Button("Add to workspace");
        this.amountAddWorkspace.setOnAction(event -> this.addCurrentItemToWorkspace());
        this.amountAddWorkspace.setMaxHeight(Double.MAX_VALUE);
        this.amountAddWorkspace.setTooltip(new Tooltip("Add current selection to workspace with given amount"));
        this.amountAddWorkspace.setDisable(true);
        controlLine.getChildren().add((Object)this.amountAddWorkspace);
        controlLine = new HBox();
        controlLine.setSpacing(10.0);
        controlPane.getChildren().add((Object)controlLine);
        controlLine.getChildren().add((Object)new Text("Filename"));
        this.filtFilename = new TextField();
        this.filtFilename.textProperty().addListener(c -> this.refreshFilterAndTable());
        this.filtFilename.setPrefWidth(250.0);
        HBox.setHgrow((Node)this.filtFilename, (Priority)Priority.ALWAYS);
        controlLine.getChildren().add((Object)this.filtFilename);
        controlLine.getChildren().add((Object)new Text("Author"));
        this.filtAuthor = new TextField();
        this.filtAuthor.textProperty().addListener(c -> this.refreshFilterAndTable());
        this.filtAuthor.setPrefWidth(250.0);
        HBox.setHgrow((Node)this.filtAuthor, (Priority)Priority.ALWAYS);
        controlLine.getChildren().add((Object)this.filtAuthor);
        this.filtOrigin = new ComboBox();
        this.filtOrigin.setPrefWidth(180.0);
        this.filtOrigin.getItems().addAll((Object[])LDIVSOriginFilter.values());
        this.filtOrigin.getSelectionModel().clearAndSelect(0);
        this.filtOrigin.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> this.refreshFilterAndTable());
        HBox.setHgrow(this.filtOrigin, (Priority)Priority.ALWAYS);
        controlLine.getChildren().add(this.filtOrigin);
        this.filtWord = new ComboBox();
        this.filtWord.setPrefWidth(190.0);
        this.filtWord.getItems().addAll((Object[])LDIVSWordFilter.values());
        this.filtWord.getSelectionModel().clearAndSelect(0);
        this.filtWord.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> this.refreshFilterAndTable());
        controlLine.getChildren().add(this.filtWord);
        controlLine = new HBox();
        controlLine.setSpacing(10.0);
        controlPane.getChildren().add((Object)controlLine);
        controlLine.getChildren().add((Object)new Text("Description"));
        this.filtDescription = new TextField();
        this.filtDescription.textProperty().addListener(c -> this.refreshFilterAndTable());
        this.filtDescription.setPrefWidth(250.0);
        HBox.setHgrow((Node)this.filtDescription, (Priority)Priority.ALWAYS);
        controlLine.getChildren().add((Object)this.filtDescription);
        this.statistics = new Text("99999 / 99999");
        controlLine.getChildren().add((Object)this.statistics);
        TableColumn nameColumn = new TableColumn("Item");
        nameColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((LDrawPart)param.getValue()).loadedFromFilename));
        nameColumn.setPrefWidth(150.0);
        nameColumn.setMinWidth(100.0);
        TableColumn originColumn = new TableColumn("Orig.");
        originColumn.setCellValueFactory(param -> {
            LDrawPartOrigin o = ((LDrawPart)param.getValue()).origin;
            if (o == null) {
                o = LDrawPartOrigin.MISSING;
            }
            return new ReadOnlyStringWrapper(o.nameFull);
        });
        originColumn.setCellFactory((Callback)new Callback<TableColumn<LDrawPart, String>, TableCell<LDrawPart, String>>(){

            public TableCell<LDrawPart, String> call(TableColumn<LDrawPart, String> p) {
                return new TableCell<LDrawPart, String>(){
                    private final Circle orgPreview = new Circle(8.0, (Paint)Color.WHITE);

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item);
                            LDrawPartOrigin o = LDrawPartOrigin.getByFullName(item);
                            this.orgPreview.setFill((Paint)GuiHelper.rgbaToColor(o.rgbaCol));
                            this.setGraphic((Node)this.orgPreview);
                            this.setTooltip(new Tooltip(o.explanation));
                        } else {
                            this.setText("");
                            this.setGraphic(null);
                            this.setTooltip(null);
                        }
                    }
                };
            }
        });
        originColumn.setPrefWidth(60.0);
        TableColumn descColumn = new TableColumn("Description");
        descColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((LDrawPart)param.getValue()).description));
        descColumn.setPrefWidth(430.0);
        descColumn.setMinWidth(100.0);
        TableColumn authColumn = new TableColumn("Author");
        authColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((LDrawPart)param.getValue()).author));
        authColumn.setPrefWidth(170.0);
        authColumn.setMinWidth(100.0);
        this.rankMap = new HashMap();
        this.rankColumn = new TableColumn("Rank");
        this.rankColumn.setVisible(false);
        this.rankColumn.setCellValueFactory(param -> {
            Integer rankO = this.rankMap.get(param.getValue());
            if (rankO == null) {
                return null;
            }
            int rank = rankO;
            return new ReadOnlyIntegerWrapper(rank);
        });
        this.rankColumn.setPrefWidth(60.0);
        this.rankColumn.setMinWidth(60.0);
        this.entries = FXCollections.observableArrayList();
        this.filteredEntries = new FilteredList(this.entries);
        SortedList sortedEntries = new SortedList(this.filteredEntries);
        this.tableView = new TableView();
        sortedEntries.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        this.tableView.setItems((ObservableList)sortedEntries);
        this.tableView.setManaged(true);
        this.tableView.setPlaceholder((Node)new Label("No item to show (selection has no or empty list or all items are filtered)"));
        nameColumn.setReorderable(false);
        originColumn.setReorderable(false);
        descColumn.setReorderable(false);
        authColumn.setReorderable(false);
        this.rankColumn.setReorderable(false);
        this.tableView.getColumns().add((Object)nameColumn);
        this.tableView.getColumns().add((Object)originColumn);
        this.tableView.getColumns().add((Object)descColumn);
        this.tableView.getColumns().add((Object)authColumn);
        this.tableView.getColumns().add(this.rankColumn);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.getSelectionModel().setCellSelectionEnabled(false);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((obs, oldSel, newSel) -> this.partInTableSelUpdated((ObservableValue<? extends LDrawPart>)obs, (LDrawPart)oldSel, (LDrawPart)newSel));
        this.setCenter((Node)this.tableView);
    }

    @Override
    public void contextChanged() {
        this.colorSelect.getItems().clear();
        this.colorSelect.getItems().addAll(this.main.ctx.getColors());
        this.colorSelect.getSelectionModel().select((Object)this.main.ctx.getColorById(0));
        this.contextValid = false;
        this.previewValid = false;
        if (this.isTabSelected) {
            this.rebuildTable();
        }
    }

    @Override
    public void invalidateItem(TreeItem<LDIData> invalid) {
    }

    @Override
    public void onTabSelection(boolean state) {
        if (!this.isTabSelected && state && !this.previewValid) {
            this.isTabSelected = true;
            this.rebuildTable();
        } else {
            this.isTabSelected = state;
        }
    }

    @Override
    public void selUpdated(ObservableValue<? extends TreeItem<LDIData>> obs, TreeItem<LDIData> oldSel, TreeItem<LDIData> newSel, boolean active) {
        this.curMainSelect = newSel;
        this.curPartList = this.main.getAsUnfixedPartList(newSel);
        this.updateAddButtonStates();
    }

    public void initDialogPartSearch(String partname, String description, int colId, int dispAmount) {
        this.asDialog = true;
        this.contextChanged();
        LDICColor col = this.main.ctx.getColorById(colId);
        if (col != null) {
            this.colorSelect.getSelectionModel().select((Object)col);
        }
        this.amount.setText(Integer.toString(dispAmount));
        this.amount.setDisable(true);
        this.amountAddList.setVisible(false);
        this.amountAddWorkspace.setVisible(false);
        this.isTabSelected = true;
        this.filtFilename.setText(partname);
        this.filtDescription.setText(description);
        this.filtWord.setValue((Object)LDIVSWordFilter.RANK);
        this.refreshFilterAndTable();
        this.rebuildTable();
    }

    public LDrawPart getSelectedPart() {
        return this.curTableSelect;
    }

    private void updateAddButtonStates() {
        this.amountAddList.setDisable(this.curPartList == null || this.curTableSelect == null);
        this.amountAddWorkspace.setDisable(this.curTableSelect == null);
    }

    private void addCurrentItemToPartList() {
        if (this.curPartList == null || this.curTableSelect == null) {
            return;
        }
        LDICColor selectedColor = (LDICColor)this.colorSelect.getSelectionModel().getSelectedItem();
        int colId = selectedColor == null ? 0 : selectedColor.id;
        int count = 1;
        try {
            count = Integer.parseInt(this.amount.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.curPartList.addPart(this.curTableSelect.loadedFromFilename, colId, count, this.curTableSelect.origin, false);
        this.main.rebuildItem(this.curMainSelect);
    }

    private void addCurrentItemToWorkspace() {
        if (this.curTableSelect == null) {
            return;
        }
        LDICColor selectedColor = (LDICColor)this.colorSelect.getSelectionModel().getSelectedItem();
        int colId = selectedColor == null ? 0 : selectedColor.id;
        int count = 1;
        try {
            count = Integer.parseInt(this.amount.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.main.addDataItem(new LDIDLooseItem(this.curTableSelect.loadedFromFilename, colId, count));
    }

    private boolean checkWords(String in, String[] chks) {
        if (in == null) {
            return true;
        }
        in = in.toLowerCase();
        String[] stringArray = chks;
        int n = chks.length;
        int n2 = 0;
        while (n2 < n) {
            String chk = stringArray[n2];
            if ((chk = chk.trim()).length() != 0 && !in.contains(chk)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private int countWords(String in, String[] chks) {
        if (in == null) {
            return 0;
        }
        int cnt = 0;
        in = in.toLowerCase();
        if (chks.length > 12) {
            String[] stringArray = chks;
            int n = chks.length;
            int n2 = 0;
            while (n2 < n) {
                String chk = stringArray[n2];
                if ((chk = chk.trim()).length() != 0 && in.contains(chk)) {
                    ++cnt;
                }
                ++n2;
            }
        } else {
            in = in.replaceAll("\\s", "");
            int max = 1 << chks.length;
            StringBuilder sb = new StringBuilder();
            int i = 1;
            while (i < max) {
                sb.setLength(0);
                int j = 0;
                while (j < chks.length) {
                    if ((i & 1 << j) != 0) {
                        sb.append(chks[j]);
                    }
                    ++j;
                }
                if (in.contains(sb.toString())) {
                    ++cnt;
                }
                ++i;
            }
        }
        return cnt;
    }

    private String removeSpecialChars(String text) {
        return text.replaceAll("[^a-z0-9]", " ").replaceAll("\\s+", " ");
    }

    private void refreshFilterAndTable() {
        if (!this.contextValid || !this.isTabSelected) {
            return;
        }
        LDIVSWordFilter word = (LDIVSWordFilter)((Object)this.filtWord.getValue());
        LDIVSOriginFilter origin = (LDIVSOriginFilter)((Object)this.filtOrigin.getValue());
        this.rankMap.clear();
        if (word == LDIVSWordFilter.COMPLETE) {
            String filename = this.filtFilename.getText().toLowerCase();
            String description = this.filtDescription.getText().toLowerCase();
            String author = this.filtAuthor.getText().toLowerCase();
            this.rankColumn.setVisible(false);
            this.filteredEntries.setPredicate(p -> {
                if (origin != LDIVSOriginFilter.ALL && lDIVSOriginFilter.reqOrigin != p.origin) {
                    return false;
                }
                if (filename.length() > 0 && !p.loadedFromFilename.toLowerCase().contains(filename)) {
                    return false;
                }
                if (!(description.length() <= 0 || p.description != null && p.description.toLowerCase().contains(description))) {
                    return false;
                }
                return author.length() <= 0 || p.author != null && p.author.toLowerCase().contains(author);
            });
        } else {
            String filename = this.removeSpecialChars(this.filtFilename.getText().toLowerCase());
            String description = this.removeSpecialChars(this.filtDescription.getText().toLowerCase());
            String author = this.removeSpecialChars(this.filtAuthor.getText().toLowerCase());
            if (word == LDIVSWordFilter.WORDS) {
                this.rankColumn.setVisible(false);
                String[] wfilenames = filename.length() == 0 ? null : filename.split(" ");
                String[] wdescriptions = description.length() == 0 ? null : description.split(" ");
                String[] wauthors = author.length() == 0 ? null : author.split(" ");
                this.filteredEntries.setPredicate(p -> {
                    if (origin != LDIVSOriginFilter.ALL && lDIVSOriginFilter.reqOrigin != p.origin) {
                        return false;
                    }
                    if (wfilenames != null && !this.checkWords(p.loadedFromFilename, wfilenames)) {
                        return false;
                    }
                    if (wdescriptions != null && !this.checkWords(p.description, wdescriptions)) {
                        return false;
                    }
                    return wauthors == null || this.checkWords(p.author, wauthors);
                });
            } else {
                if (!this.rankColumn.isVisible()) {
                    this.rankColumn.setVisible(true);
                    this.rankColumn.setSortType(TableColumn.SortType.DESCENDING);
                    this.tableView.getSortOrder().add(this.rankColumn);
                }
                String[] ffilenames = filename.length() == 0 ? null : filename.split(" ");
                String[] fdescriptions = description.length() == 0 ? null : description.split(" ");
                String[] fauthors = author.length() == 0 ? null : author.split(" ");
                this.filteredEntries.setPredicate(p -> {
                    int r;
                    int rank = 0;
                    if (origin != LDIVSOriginFilter.ALL && lDIVSOriginFilter.reqOrigin != p.origin) {
                        return false;
                    }
                    if (ffilenames != null) {
                        r = this.countWords(p.loadedFromFilename, ffilenames);
                        rank += r;
                    }
                    if (fdescriptions != null) {
                        r = this.countWords(p.description, fdescriptions);
                        rank += r;
                    }
                    if (fauthors != null) {
                        r = this.countWords(p.author, fauthors);
                        rank += r;
                    }
                    if (rank == 0) {
                        return false;
                    }
                    this.rankMap.put((LDrawPart)p, rank);
                    return true;
                });
            }
        }
        this.tableView.refresh();
        this.updateAddButtonStates();
        this.statistics.setText(String.valueOf(this.filteredEntries.size()) + " / " + this.entries.size());
        this.refreshPreview();
    }

    private void partInTableSelUpdated(ObservableValue<? extends LDrawPart> obs, LDrawPart oldSel, LDrawPart newSel) {
        this.curTableSelect = newSel;
        this.previewPart.renderGroup.getChildren().clear();
        this.updateAddButtonStates();
        if (this.curTableSelect == null) {
            return;
        }
        this.refreshPreview();
    }

    private void refreshPreview() {
        LDICColor selectedColor;
        int colId;
        this.previewPart.renderGroup.getChildren().clear();
        if (this.curTableSelect == null) {
            return;
        }
        LDrawPart toRender = this.main.ctx.getPart(null, this.curTableSelect.loadedFromFilename, this.main);
        LDIPartRender lbcColored = LDIPartRender.buildPartAtOrigin(this.main.ctx, toRender, colId = (selectedColor = (LDICColor)this.colorSelect.getSelectionModel().getSelectedItem()) != null ? selectedColor.id : 16, -1, this.main);
        if (lbcColored != null) {
            this.previewSet.resetView();
            this.previewPart.renderGroup.getChildren().add((Object)lbcColored.dest);
            this.previewPart.autoAdjustView();
        }
    }

    private void rebuildTable() {
        if (this.contextValid) {
            this.previewValid = true;
            this.refreshFilterAndTable();
            return;
        }
        this.entries.clear();
        if (!this.asDialog) {
            this.main.runAndWait("Loading part list...", new Task<Void>(){

                protected Void call() {
                    final List<LDrawPart> list = LDIVSearch.this.main.ctx.getAllPartHeaders(LDIVSearch.this.main);
                    list.sort((o1, o2) -> StringNumberComparator.compare(o1.loadedFromFilename, o2.loadedFromFilename));
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).LDIVSearch.this.entries.addAll((Collection)list);
                            (this).LDIVSearch.this.contextValid = true;
                            LDIVSearch.this.rebuildTable();
                        }
                    });
                    return null;
                }
            });
        } else {
            List<LDrawPart> list = this.main.ctx.getAllPartHeaders(this.main);
            list.sort((o1, o2) -> StringNumberComparator.compare(o1.loadedFromFilename, o2.loadedFromFilename));
            this.entries.addAll(list);
            this.contextValid = true;
            this.rebuildTable();
        }
    }

    private static enum LDIVSOriginFilter {
        ALL("all origins", null),
        OFFICIAL("official only", LDrawPartOrigin.OFFICIAL),
        UNOFFICIAL("unofficial only", LDrawPartOrigin.UNOFFICIAL);

        public final String text;
        public final LDrawPartOrigin reqOrigin;

        private LDIVSOriginFilter(String itext, LDrawPartOrigin ireq) {
            this.text = itext;
            this.reqOrigin = ireq;
        }

        public String toString() {
            return this.text;
        }
    }

    private static enum LDIVSWordFilter {
        COMPLETE("complete string"),
        WORDS("words exactly"),
        RANK("rank matches");

        public final String text;

        private LDIVSWordFilter(String itext) {
            this.text = itext;
        }

        public String toString() {
            return this.text;
        }
    }
}

