/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import ldinsp.data.LDIData;
import ldinsp.gui.GuiHelper;
import ldinsp.gui.LDIGui;
import ldinsp.gui.view.LDIView;
import ldinsp.ldraw.LDrawEdit;
import ldinsp.ldraw.LDrawPart;

public class LDIVEdit
extends VBox
implements LDIView {
    private final LDIGui main;
    private final Button refreshButton;
    private final BorderPane noDetailPane;
    private final VBox partPane;
    private final Text resultText;
    private final TextField givenFilename;
    private final TextField givenName;
    private final TextField author;
    private final TextField description;
    private final TextField license;
    private boolean isTabSelected;
    private TreeItem<LDIData> item;
    private TreeItem<LDIData> changeableItem;
    private LDrawPart part;

    public LDIVEdit(LDIGui imain) {
        this.main = imain;
        this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.setSpacing(10.0);
        HBox line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().add((Object)line);
        this.refreshButton = new Button("Refresh item");
        this.refreshButton.setOnAction(event -> this.main.refreshItem(this.item));
        this.refreshButton.setMaxHeight(Double.MAX_VALUE);
        line.getChildren().add((Object)this.refreshButton);
        line.getChildren().add((Object)new Text("Refresh item (reload file, rescan directory...)"));
        StackPane detailPane = new StackPane();
        VBox.setVgrow((Node)detailPane, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)detailPane);
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().add((Object)line);
        this.noDetailPane = new BorderPane();
        detailPane.getChildren().add((Object)this.noDetailPane);
        this.noDetailPane.setCenter((Node)new Text("No item selected or no details available for selected item."));
        this.partPane = new VBox();
        detailPane.getChildren().add((Object)this.partPane);
        line = new HBox();
        line.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        line.setAlignment(Pos.CENTER);
        line.setStyle("-fx-background-color: #F73F3F;");
        this.partPane.getChildren().add((Object)line);
        Text attention = new Text("Attention! Activating red buttons will modify your file without further confirmation!");
        line.getChildren().add((Object)attention);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Result of last edit operation:"));
        this.resultText = new Text();
        line.getChildren().add((Object)this.resultText);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Given filename"));
        this.givenFilename = new TextField();
        this.givenFilename.setPrefWidth(200.0);
        HBox.setHgrow((Node)this.givenFilename, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.givenFilename);
        CheckBox renameFixRefs = new CheckBox("Fix refs.");
        renameFixRefs.setSelected(true);
        line.getChildren().add((Object)renameFixRefs);
        Button button = new Button("Set");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.setGivenFilename(this.givenFilename.getText(), renameFixRefs.isSelected()));
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Given name"));
        this.givenName = new TextField();
        this.givenName.setPrefWidth(200.0);
        HBox.setHgrow((Node)this.givenName, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.givenName);
        button = new Button("Set");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.setGivenName(this.givenName.getText()));
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Author"));
        this.author = new TextField();
        this.author.setPrefWidth(200.0);
        HBox.setHgrow((Node)this.author, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.author);
        button = new Button("<<def");
        button.setOnAction(event -> {
            String defAuthor = this.main.ctx.getDefaultAuthor();
            if (defAuthor == null) {
                if (GuiHelper.yesNo(Alert.AlertType.CONFIRMATION, "Author not configured", "Default author is not configured yes", "Do you want to configure your workspace now?", false, false)) {
                    this.main.configContext();
                } else {
                    GuiHelper.fixPrimaryStage();
                }
                return;
            }
            this.author.setText(defAuthor);
        });
        line.getChildren().add((Object)button);
        CheckBox authorRecursive = new CheckBox("Recursive");
        authorRecursive.setSelected(true);
        line.getChildren().add((Object)authorRecursive);
        CheckBox authorOverwrite = new CheckBox("Ovr. existing");
        authorOverwrite.setSelected(true);
        line.getChildren().add((Object)authorOverwrite);
        button = new Button("Set");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.setAuthor(authorRecursive.isSelected(), authorOverwrite.isSelected()));
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Description"));
        this.description = new TextField();
        this.description.setPrefWidth(200.0);
        HBox.setHgrow((Node)this.description, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.description);
        button = new Button("Set");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.setDescription());
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("License"));
        this.license = new TextField();
        this.license.setText("Redistributable under CCAL version 2.0 : see CAreadme.txt");
        this.license.setPrefWidth(200.0);
        HBox.setHgrow((Node)this.license, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.license);
        button = new Button("<<OMR");
        button.setOnAction(event -> this.license.setText("Redistributable under CCAL version 2.0 : see CAreadme.txt"));
        line.getChildren().add((Object)button);
        CheckBox licenseRecursive = new CheckBox("Recursive");
        licenseRecursive.setSelected(true);
        line.getChildren().add((Object)licenseRecursive);
        CheckBox licenseOverwrite = new CheckBox("Ovr. existing");
        licenseOverwrite.setSelected(true);
        line.getChildren().add((Object)licenseOverwrite);
        button = new Button("Set");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.setLicense(licenseRecursive.isSelected(), licenseOverwrite.isSelected()));
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Several"));
        CheckBox severalRecursive = new CheckBox("Recursive");
        severalRecursive.setSelected(true);
        line.getChildren().add((Object)severalRecursive);
        button = new Button("Sync given name to filename");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.syncNames(severalRecursive.isSelected()));
        line.getChildren().add((Object)button);
        button = new Button("Resolve ~moved part refs.");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.resolveMoved(severalRecursive.isSelected()));
        line.getChildren().add((Object)button);
        button = new Button("Remove unresolvable part refs.");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.removeUnresolvable(severalRecursive.isSelected()));
        line.getChildren().add((Object)button);
        line = new HBox();
        line.setSpacing(10.0);
        line.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        line.setAlignment(Pos.CENTER_LEFT);
        this.partPane.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Exchange part ref."));
        TextField renameRefOld = new TextField();
        HBox.setHgrow((Node)renameRefOld, (Priority)Priority.ALWAYS);
        renameRefOld.setPrefWidth(100.0);
        renameRefOld.setTooltip(new Tooltip("include file ending"));
        line.getChildren().add((Object)renameRefOld);
        line.getChildren().add((Object)new Text("=>"));
        TextField renameRefNew = new TextField();
        HBox.setHgrow((Node)renameRefNew, (Priority)Priority.ALWAYS);
        renameRefNew.setPrefWidth(100.0);
        renameRefNew.setTooltip(new Tooltip("include file ending"));
        line.getChildren().add((Object)renameRefNew);
        CheckBox renameRecursive = new CheckBox("Recursive");
        renameRecursive.setSelected(true);
        line.getChildren().add((Object)renameRecursive);
        button = new Button("Exchange");
        button.setStyle("-fx-base: #F73F3F;");
        button.setOnAction(event -> this.exchangeRef(renameRefOld.getText(), renameRefNew.getText(), renameRecursive.isSelected()));
        line.getChildren().add((Object)button);
    }

    @Override
    public void contextChanged() {
        String defAuthor;
        if (this.author.getText().length() == 0 && (defAuthor = this.main.ctx.getDefaultAuthor()) != null) {
            this.author.setText(defAuthor);
        }
        this.refresh();
    }

    @Override
    public void invalidateItem(TreeItem<LDIData> invalid) {
        this.refresh();
    }

    @Override
    public void onTabSelection(boolean state) {
        this.isTabSelected = state;
        this.refresh();
    }

    @Override
    public void selUpdated(ObservableValue<? extends TreeItem<LDIData>> obs, TreeItem<LDIData> oldSel, TreeItem<LDIData> newSel, boolean active) {
        this.item = newSel;
        this.refresh();
    }

    private void refresh() {
        LDIData data;
        this.changeableItem = null;
        this.part = null;
        this.resultText.setText("");
        if (!this.isTabSelected) {
            return;
        }
        if (this.item == null || (data = (LDIData)this.item.getValue()) == null || (this.part = data.getPart(this.main.ctx)) == null) {
            this.refreshButton.setDisable(true);
            this.noDetailPane.setVisible(true);
            this.partPane.setVisible(false);
            return;
        }
        this.refreshButton.setDisable(false);
        this.givenFilename.setText(this.part.givenFilename != null ? this.part.givenFilename : "");
        this.givenName.setText(this.part.givenName != null ? this.part.givenName : "");
        this.author.setText(this.part.author);
        this.description.setText(this.part.description);
        this.license.setText(this.part.license);
        this.noDetailPane.setVisible(false);
        this.partPane.setVisible(true);
        this.changeableItem = this.main.getChangeableFile(this.item);
        this.partPane.setDisable(this.changeableItem == null);
    }

    private void setGivenFilename(String newName, boolean fixRefs) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.renamePart(this.part, newName, fixRefs);
        this.main.reexportChangedFile(this.changeableItem);
        this.resultText.setText("Lines changed to set given filename: " + cnt);
    }

    private void setGivenName(String newName) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.setGivenName(this.part, newName);
        this.main.reexportChangedFile(this.changeableItem);
        this.resultText.setText("Lines changed to set given name: " + cnt);
    }

    private void setAuthor(boolean recursive, boolean overwrite) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.setAuthor(this.part, this.author.getText(), recursive, overwrite, false);
        this.main.reexportChangedFile(this.changeableItem);
        this.resultText.setText("Lines changed to set author: " + cnt);
    }

    private void setDescription() {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.setDescription(this.part, this.description.getText());
        this.main.reexportChangedFile(this.changeableItem);
        this.resultText.setText("Lines changed to set license: " + cnt);
    }

    private void setLicense(boolean recursive, boolean overwrite) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.setLicense(this.part, this.license.getText(), recursive, overwrite, false);
        this.main.reexportChangedFile(this.changeableItem);
        this.resultText.setText("Lines changed to set license: " + cnt);
    }

    private void syncNames(boolean recursive) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.syncName(this.part, recursive);
        this.main.reexportChangedFile(this.changeableItem);
        this.resultText.setText("Lines changed to sync names: " + cnt);
    }

    private void resolveMoved(boolean recursive) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.resolveMoved(this.part, this.main.ctx, recursive);
        this.main.reexportChangedFile(this.changeableItem);
        this.resultText.setText("Lines changed to resolve moved part refs: " + cnt);
    }

    private void removeUnresolvable(boolean recursive) {
        if (this.changeableItem == null || this.part == null) {
            return;
        }
        int cnt = LDrawEdit.removeUnresolvableRefs(this.part, this.main.ctx, recursive);
        this.main.reexportChangedFile(this.changeableItem);
        this.resultText.setText("Lines changed to remove unresolvable part refs: " + cnt);
    }

    private void exchangeRef(String oldRef, String newRef, boolean recursive) {
        if (this.changeableItem == null || this.part == null || oldRef == null || oldRef.length() == 0 || newRef == null || newRef.length() == 0) {
            return;
        }
        int cnt = LDrawEdit.exchangeRef(this.part, oldRef, newRef, recursive);
        this.main.reexportChangedFile(this.changeableItem);
        this.resultText.setText("Lines changed to exchange reference: " + cnt);
    }
}

