/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Box;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import ldinsp.gui.view.LDIPartSceneSettings;

public class LDIPartScene {
    private static final double BUTTON_CAM_VIEW_STEP = 5.0;
    private static final double BUTTON_CAM_DIST_STEP = 50.0;
    private static final double CAMERA_NEAR_CLIP = 0.1;
    private static final double CAMERA_FAR_CLIP = 10000.0;
    private static final double AXIS_LENGTH = 50.0;
    private static final double AXIS_WIDTH = 1.0;
    public final PerspectiveCamera renderCamera;
    public final Group axesGroup = new Group();
    public final Group renderGroup = new Group();
    public final Group world = new Group();
    public final SubScene objectScene;
    public final LDIPartSceneSettings settings;
    private boolean mouseRotateNotPan;
    private double anchorX;
    private double anchorY;
    private double anchorAngleX;
    private double anchorAngleY;

    public LDIPartScene(int width, int height, LDIPartSceneSettings isettings) {
        this.settings = isettings;
        this.setupAxes();
        this.world.getChildren().add((Object)this.axesGroup);
        this.world.getChildren().add((Object)this.renderGroup);
        this.objectScene = new SubScene((Parent)this.world, (double)width, (double)height, true, SceneAntialiasing.BALANCED);
        this.renderCamera = new PerspectiveCamera(true);
        this.setupCamera();
        this.objectScene.setCamera((Camera)this.renderCamera);
        this.initMouseControl(this.world, this.objectScene);
        this.settings.resetView();
    }

    public void autoAdjustView() {
        Bounds b = this.renderGroup.getBoundsInLocal();
        double dia = Math.max(Math.max(b.getWidth(), b.getHeight()), b.getDepth());
        if (dia < 1.0) {
            return;
        }
        double angle = this.settings.camFieldView.get();
        this.settings.camDistX.set(this.round(b.getCenterX(), 5.0));
        this.settings.camDistY.set(this.round(b.getCenterY(), 5.0));
        this.settings.camDistZ.set(this.round(b.getCenterZ() - dia / Math.tan(Math.toRadians(angle / 2.0)), 50.0));
    }

    private void setupCamera() {
        this.renderCamera.setNearClip(0.1);
        this.renderCamera.setFarClip(10000.0);
        this.renderCamera.fieldOfViewProperty().bind((ObservableValue)this.settings.camFieldView);
        Translate allTranslate = new Translate(0.0, 0.0, 0.0);
        this.renderCamera.getTransforms().add((Object)allTranslate);
        Rotate xRotate = new Rotate(0.0, Rotate.X_AXIS);
        this.renderCamera.getTransforms().add((Object)xRotate);
        Rotate yRotate = new Rotate(0.0, Rotate.Y_AXIS);
        this.renderCamera.getTransforms().add((Object)yRotate);
        Rotate zRotate = new Rotate(0.0, Rotate.Z_AXIS);
        this.renderCamera.getTransforms().add((Object)zRotate);
        allTranslate.xProperty().bind((ObservableValue)this.settings.camDistX);
        allTranslate.yProperty().bind((ObservableValue)this.settings.camDistY);
        allTranslate.zProperty().bind((ObservableValue)this.settings.camDistZ);
        xRotate.angleProperty().bind((ObservableValue)this.settings.camAngleX);
        yRotate.angleProperty().bind((ObservableValue)this.settings.camAngleY);
        zRotate.angleProperty().bind((ObservableValue)this.settings.camAngleZ);
    }

    private void setupAxes() {
        this.axesGroup.getChildren().add((Object)LDIPartScene.buildAxis(50.0, 1.0, 1.0, Color.DARKRED, Color.RED));
        this.axesGroup.getChildren().add((Object)LDIPartScene.buildAxis(1.0, 50.0, 1.0, Color.DARKGREEN, Color.GREEN));
        this.axesGroup.getChildren().add((Object)LDIPartScene.buildAxis(1.0, 1.0, 50.0, Color.DARKBLUE, Color.BLUE));
    }

    private static Box buildAxis(double dx, double dy, double dz, Color diffuse, Color specular) {
        Box box = new Box(dx, dy, dz);
        PhongMaterial material = new PhongMaterial(diffuse);
        if (specular != null) {
            material.setSpecularColor(specular);
        }
        box.setMaterial((Material)material);
        return box;
    }

    private void initMouseControl(Group group, SubScene scene) {
        Object[] objectArray = new Transform[3];
        Rotate xRotate = new Rotate(0.0, Rotate.X_AXIS);
        objectArray[0] = xRotate;
        Rotate yRotate = new Rotate(0.0, Rotate.Y_AXIS);
        objectArray[1] = yRotate;
        Rotate zRotate = new Rotate(0.0, Rotate.Z_AXIS);
        objectArray[2] = zRotate;
        group.getTransforms().addAll(objectArray);
        xRotate.angleProperty().bind((ObservableValue)this.settings.objAngleX);
        yRotate.angleProperty().bind((ObservableValue)this.settings.objAngleY);
        zRotate.angleProperty().bind((ObservableValue)this.settings.objAngleZ);
        scene.setOnMousePressed(event -> {
            this.mouseRotateNotPan = !event.isShiftDown();
            this.anchorX = event.getSceneX();
            this.anchorY = event.getSceneY();
            if (this.mouseRotateNotPan) {
                this.anchorAngleX = this.settings.objAngleX.get();
                this.anchorAngleY = this.settings.objAngleY.get();
            } else {
                this.anchorAngleX = this.settings.camDistX.get();
                this.anchorAngleY = this.settings.camDistY.get();
            }
        });
        scene.setOnMouseDragged(event -> {
            if (this.mouseRotateNotPan) {
                this.settings.objAngleX.set(this.anchorAngleX - (this.anchorY - event.getSceneY()));
                this.settings.objAngleY.set(this.anchorAngleY + (this.anchorX - event.getSceneX()));
            } else {
                this.settings.camDistX.set(this.anchorAngleX - (event.getSceneX() - this.anchorX) / 3.0);
                this.settings.camDistY.set(this.anchorAngleY + (this.anchorY - event.getSceneY()) / 3.0);
            }
        });
        scene.setOnScroll(event -> this.settings.camDistZ.set(this.settings.camDistZ.get() + event.getDeltaY()));
    }

    private double round(double number, double multiple) {
        double frac = number % multiple;
        number -= frac;
        if (frac >= 0.5 * multiple) {
            number += multiple;
        }
        return number;
    }
}

