/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.shape.VertexFormat;
import ldinsp.base.LDILogger;
import ldinsp.base.LDIWorker;
import ldinsp.check.LDICheckMessage;
import ldinsp.context.LDIContext;
import ldinsp.data.LDIData;
import ldinsp.gui.GuiHelper;
import ldinsp.gui.view.LDIPartScene;
import ldinsp.gui.view.LDIPartSceneSettings;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawLineLine;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawLineQuad;
import ldinsp.ldraw.LDrawLineStep;
import ldinsp.ldraw.LDrawLineTri;
import ldinsp.ldraw.LDrawMatrix;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPoint;

public class LDIPartRender
extends LDIWorker {
    private static final double HALF_LINE_WIDTH = 0.2;
    public int ldrPoints;
    public int ldrLines;
    public int ldrLinesSkipped;
    public int ldrTris;
    public int ldrQuads;
    public int fxPoints;
    public int fxTris;
    public final Group dest;
    public final ArrayList<Group> stepDests = new ArrayList();
    private final LDIContext ctx;
    private final LDILogger logger;
    private final ArrayList<HashMap<Integer, TriangleMesh>> meshes = new ArrayList();
    private final boolean colByError;
    private final HashMap<LDrawLine, ArrayList<LDICheckMessage>> partErrors;
    private final int maxDrawLines;
    private final int[] ERR_COLORS = new int[]{0x3F7F3FFF, 0x7FCFFF, -65281, -16776961, -16711681};
    private int level;
    private int curStep;
    private int curErrorLevel;
    private int nextErrorLevel;

    public static Image renderImage(LDrawPart part, int colId, int width, int height, LDIContext ctx, LDILogger logger) {
        LDIPartSceneSettings previewSet = new LDIPartSceneSettings();
        LDIPartScene previewPart = new LDIPartScene(width, height, previewSet);
        previewPart.axesGroup.setVisible(false);
        previewPart.objectScene.setFill((Paint)Color.WHITE);
        LDIPartRender me = LDIPartRender.buildPartAtOrigin(ctx, part, colId, null, -1, logger);
        previewSet.resetView();
        previewPart.renderGroup.getChildren().add((Object)me.dest);
        previewPart.autoAdjustView();
        Group root = new Group();
        root.getChildren().add((Object)previewPart.objectScene);
        Scene scene = new Scene((Parent)root);
        WritableImage img = new WritableImage(width, height);
        scene.snapshot(img);
        return img;
    }

    public static LDIPartRender buildPartAtOrigin(LDIContext ictx, LDIData data, int imaxDrawLines, LDILogger logger) {
        return LDIPartRender.buildPartAtOrigin(ictx, data.getPart(ictx), data.getColId(), null, imaxDrawLines, logger);
    }

    public static LDIPartRender buildPartAtOrigin(LDIContext ictx, LDrawPart part, int useColorId, int imaxDrawLines, LDILogger logger) {
        return LDIPartRender.buildPartAtOrigin(ictx, part, useColorId, null, imaxDrawLines, logger);
    }

    public static LDIPartRender buildPartAtOriginWithStat(LDIContext ictx, LDIData data, int useColorId, HashMap<LDrawLine, ArrayList<LDICheckMessage>> ipartErrors, int imaxDrawLines, LDILogger logger) {
        LDrawPart part = data.getPart(ictx);
        if (part == null) {
            if (logger != null) {
                logger.log("no part found for " + data.getName());
            }
            return null;
        }
        if (logger != null) {
            logger.log("Starting to build " + data.getName());
        }
        long millis = -System.currentTimeMillis();
        LDIPartRender lbc = LDIPartRender.buildPartAtOrigin(ictx, part, useColorId, ipartErrors, imaxDrawLines, logger);
        millis += System.currentTimeMillis();
        if (logger != null) {
            logger.log(String.format("Rendered %s in %d ms:\nCreated LDR points: %d, lines: %d (%d skipped), triangles: %d, quads: %d\nCreated FX points: %d, triangles: %d", data.getName(), millis, lbc.ldrPoints, lbc.ldrLines, lbc.ldrLinesSkipped, lbc.ldrTris, lbc.ldrQuads, lbc.fxPoints, lbc.fxTris));
        }
        return lbc;
    }

    public static LDIPartRender buildPartAtOrigin(LDIContext ictx, LDrawPart part, int useColorId, HashMap<LDrawLine, ArrayList<LDICheckMessage>> ipartErrors, int imaxDrawLines, LDILogger logger) {
        LDIPartRender lbc = new LDIPartRender(ictx, ipartErrors, imaxDrawLines, logger);
        if (part != null) {
            lbc.work(part, false, LDrawMatrix.ID, useColorId);
        }
        return lbc;
    }

    @Override
    public void work(LDrawPart part, boolean doHeaders, LDrawMatrix m, int colId) {
        int oldErrorColor = this.curErrorLevel;
        if (this.nextErrorLevel > this.curErrorLevel) {
            this.curErrorLevel = this.nextErrorLevel;
        }
        ++this.level;
        super.work(part, doHeaders, m, colId);
        --this.level;
        this.curErrorLevel = oldErrorColor;
    }

    @Override
    public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
        LDrawPart res = this.ctx.getPart(ref.owner, partName, this.logger);
        if (res == null) {
            this.nextErrorLevel = 4;
            if (this.logger != null) {
                this.logger.log("could not find named part " + partName);
            }
        }
        if (this.colByError) {
            this.nextErrorLevel = LDICheckMessage.getMaxErrorLevel((List<LDICheckMessage>)this.partErrors.get(ref));
        }
        return res;
    }

    @Override
    public void handleStep(LDrawLineStep step) {
        if (this.level != 1) {
            return;
        }
        ++this.curStep;
        this.createStep();
    }

    @Override
    public void handleLine(LDrawLineLine line, LDrawPoint t1, LDrawPoint t2, int colId, int pcol) {
        if (this.maxDrawLines != -1 && this.ldrLines >= this.maxDrawLines) {
            ++this.ldrLinesSkipped;
            return;
        }
        TriangleMesh mesh = this.getMeshForRgbaTris(this.ctx.getRgbaColorByIds(colId, pcol));
        int baseIndex = mesh.getPoints().size() / 3;
        mesh.getPoints().addAll(LDIPartRender.buildBoxVertices(t1, t2));
        mesh.getFaces().addAll(new int[]{baseIndex + 0, 0, baseIndex + 2, 0, baseIndex + 1, 0, baseIndex + 2, 0, baseIndex + 0, 0, baseIndex + 3, 0, baseIndex + 1, 0, baseIndex + 6, 0, baseIndex + 5, 0, baseIndex + 6, 0, baseIndex + 1, 0, baseIndex + 2, 0, baseIndex + 5, 0, baseIndex + 7, 0, baseIndex + 4, 0, baseIndex + 7, 0, baseIndex + 5, 0, baseIndex + 6, 0, baseIndex + 4, 0, baseIndex + 3, 0, baseIndex + 0, 0, baseIndex + 3, 0, baseIndex + 4, 0, baseIndex + 7, 0, baseIndex + 3, 0, baseIndex + 6, 0, baseIndex + 2, 0, baseIndex + 6, 0, baseIndex + 3, 0, baseIndex + 7, 0, baseIndex + 4, 0, baseIndex + 1, 0, baseIndex + 5, 0, baseIndex + 1, 0, baseIndex + 4, 0, baseIndex + 0, 0});
        this.ldrPoints += 2;
        ++this.ldrLines;
        this.fxPoints += 8;
        this.fxTris += 12;
    }

    @Override
    public void handleTri(LDrawLineTri tri, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, int colId, int pcol) {
        TriangleMesh mesh = this.getMeshForRgbaTris(this.colByError ? this.getErrorColor(tri) : this.ctx.getRgbaColorByIds(colId, pcol));
        int baseIndex = mesh.getPoints().size() / 3;
        mesh.getPoints().addAll(new float[]{(float)t1.x, (float)t1.y, (float)t1.z, (float)t2.x, (float)t2.y, (float)t2.z, (float)t3.x, (float)t3.y, (float)t3.z});
        if (this.getFaceInvertion()) {
            mesh.getFaces().addAll(new int[]{baseIndex + 2, 0, baseIndex + 1, 0, baseIndex + 0, 0});
        } else {
            mesh.getFaces().addAll(new int[]{baseIndex + 0, 0, baseIndex + 1, 0, baseIndex + 2, 0});
        }
        this.ldrPoints += 3;
        ++this.ldrTris;
        this.fxPoints += 3;
        ++this.fxTris;
    }

    @Override
    public void handleQuad(LDrawLineQuad quad, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, LDrawPoint t4, int colId, int pcol) {
        TriangleMesh mesh = this.getMeshForRgbaTris(this.colByError ? this.getErrorColor(quad) : this.ctx.getRgbaColorByIds(colId, pcol));
        int baseIndex = mesh.getPoints().size() / 3;
        mesh.getPoints().addAll(new float[]{(float)t1.x, (float)t1.y, (float)t1.z, (float)t2.x, (float)t2.y, (float)t2.z, (float)t3.x, (float)t3.y, (float)t3.z, (float)t4.x, (float)t4.y, (float)t4.z});
        if (this.getFaceInvertion()) {
            mesh.getFaces().addAll(new int[]{baseIndex + 0, 0, baseIndex + 2, 0, baseIndex + 1, 0, baseIndex + 2, 0, baseIndex + 0, 0, baseIndex + 3, 0});
        } else {
            mesh.getFaces().addAll(new int[]{baseIndex + 0, 0, baseIndex + 1, 0, baseIndex + 2, 0, baseIndex + 2, 0, baseIndex + 3, 0, baseIndex + 0, 0});
        }
        this.ldrPoints += 4;
        ++this.ldrQuads;
        this.fxPoints += 4;
        this.fxTris += 2;
    }

    private LDIPartRender(LDIContext ictx, HashMap<LDrawLine, ArrayList<LDICheckMessage>> ipartErrors, int imaxDrawLines, LDILogger ilogger) {
        this.dest = new Group();
        this.ctx = ictx;
        this.colByError = ipartErrors != null;
        this.partErrors = ipartErrors;
        this.nextErrorLevel = 0;
        this.curErrorLevel = 0;
        this.maxDrawLines = imaxDrawLines;
        this.logger = ilogger;
        this.createStep();
    }

    private void createStep() {
        Group cStep = new Group();
        this.stepDests.add(cStep);
        this.dest.getChildren().add((Object)cStep);
        this.meshes.add(new HashMap());
    }

    private int getErrorColor(LDrawLine ldr) {
        int plevel;
        int elevel = this.curErrorLevel;
        if (this.partErrors.containsKey(ldr) && (plevel = LDICheckMessage.getMaxErrorLevel((List<LDICheckMessage>)this.partErrors.get(ldr))) > elevel) {
            elevel = plevel;
        }
        if (elevel < 0 || elevel >= this.ERR_COLORS.length) {
            elevel = this.ERR_COLORS.length - 1;
        }
        return this.ERR_COLORS[elevel];
    }

    private TriangleMesh getMeshForRgbaTris(int rgba) {
        TriangleMesh mesh = this.meshes.get(this.curStep).get(rgba);
        if (mesh != null) {
            return mesh;
        }
        mesh = new TriangleMesh();
        mesh.setVertexFormat(VertexFormat.POINT_TEXCOORD);
        mesh.getTexCoords().addAll(new float[]{0.0f, 0.0f});
        this.meshes.get(this.curStep).put(rgba, mesh);
        MeshView view = new MeshView((Mesh)mesh);
        view.setMaterial((Material)new PhongMaterial(GuiHelper.rgbaToColor(rgba)));
        view.setCullFace(CullFace.BACK);
        view.setDrawMode(DrawMode.FILL);
        this.stepDests.get(this.curStep).getChildren().add((Object)view);
        return mesh;
    }

    private static float[] buildBoxVertices(LDrawPoint t1, LDrawPoint t2) {
        LDrawMatrix m;
        LDrawPoint mid = t1.midTo(t2);
        LDrawPoint diff = t2.subtract(t1);
        double height = diff.length();
        double hh = height / 2.0;
        LDrawPoint[] p = new LDrawPoint[]{new LDrawPoint(-0.2, -hh, -0.2), new LDrawPoint(0.2, -hh, -0.2), new LDrawPoint(0.2, hh, -0.2), new LDrawPoint(-0.2, hh, -0.2), new LDrawPoint(-0.2, -hh, 0.2), new LDrawPoint(0.2, -hh, 0.2), new LDrawPoint(0.2, hh, 0.2), new LDrawPoint(-0.2, hh, 0.2)};
        if (diff.x == 0.0 && diff.z == 0.0) {
            m = new LDrawMatrix(1.0, 0.0, 0.0, mid.x, 0.0, 1.0, 0.0, mid.y, 0.0, 0.0, 1.0, mid.z);
        } else {
            double uL = Math.sqrt(diff.x * diff.x + diff.z * diff.z);
            double uX = -diff.z / uL;
            double uZ = diff.x / uL;
            double angle = -Math.acos(diff.y / height);
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            m = new LDrawMatrix(cos + uX * uX * (1.0 - cos), -uZ * sin, uX * uZ * (1.0 - cos), mid.x, uZ * sin, cos, -uX * sin, mid.y, uX * uZ * (1.0 - cos), uX * sin, cos + uZ * uZ * (1.0 - cos), mid.z);
        }
        int i = 0;
        while (i < 8) {
            p[i] = m.apply(p[i]);
            ++i;
        }
        return new float[]{(float)p[0].x, (float)p[0].y, (float)p[0].z, (float)p[1].x, (float)p[1].y, (float)p[1].z, (float)p[2].x, (float)p[2].y, (float)p[2].z, (float)p[3].x, (float)p[3].y, (float)p[3].z, (float)p[4].x, (float)p[4].y, (float)p[4].z, (float)p[5].x, (float)p[5].y, (float)p[5].z, (float)p[6].x, (float)p[6].y, (float)p[6].z, (float)p[7].x, (float)p[7].y, (float)p[7].z};
    }
}

