/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import ldinsp.LDInspector;
import ldinsp.base.LDILogger;
import ldinsp.context.LDICPDir;
import ldinsp.context.LDICPTest;
import ldinsp.context.LDICPZip;
import ldinsp.context.LDIContext;
import ldinsp.data.LDIDDirectory;
import ldinsp.data.LDIDFile;
import ldinsp.data.LDIDLooseItem;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIData;
import ldinsp.data.LDIDataSaveable;
import ldinsp.ext.LDIPbgFiles;
import ldinsp.gui.GuiHelper;
import ldinsp.gui.LDIGConfigContext;
import ldinsp.gui.view.LDIVCheck;
import ldinsp.gui.view.LDIVEdit;
import ldinsp.gui.view.LDIVItem;
import ldinsp.gui.view.LDIVPartGrid;
import ldinsp.gui.view.LDIVPartList;
import ldinsp.gui.view.LDIVRender;
import ldinsp.gui.view.LDIVSearch;
import ldinsp.gui.view.LDIVTSource;
import ldinsp.gui.view.LDIVTUsedFiles;
import ldinsp.gui.view.LDIVText;
import ldinsp.gui.view.LDIVWeb;
import ldinsp.gui.view.LDIView;
import ldinsp.ldraw.LDrawFiles;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDIGui
implements LDILogger {
    public static final int MAX_BACKGROUND_TASKS = 2;
    public static final String STYLE_MODIFY_BASE = "-fx-base: #F73F3F;";
    public static final String STYLE_MODIFY_BACKGROUND = "-fx-background-color: #F73F3F;";
    public final HostServices services;
    public LDIContext ctx;
    private Scene scene;
    private VBox progressModalPane;
    private ProgressIndicator progressModal;
    private Label progressModalLabel;
    private ExecutorService backgroundService;
    private Text backgroundRemainingText;
    private int backgroundRemaining;
    private TreeTableView<LDIData> tableView;
    private TreeItem<LDIData> elems;
    private TabPane tabPane;
    private LDIVText log;

    public LDIGui(Stage stage, HostServices iservices) {
        GuiHelper.setPrimaryStage(stage);
        this.services = iservices;
        StackPane overlayStack = new StackPane();
        BorderPane content = new BorderPane();
        overlayStack.getChildren().add((Object)content);
        SplitPane center = new SplitPane();
        center.setDividerPositions(new double[]{0.3});
        content.setCenter((Node)center);
        this.elems = new TreeItem();
        this.elems.setExpanded(true);
        TreeTableColumn nameColumn = new TreeTableColumn("Item");
        nameColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((LDIData)param.getValue().getValue()).getName()));
        nameColumn.setPrefWidth(250.0);
        nameColumn.setMinWidth(150.0);
        nameColumn.setMaxWidth(Double.MAX_VALUE);
        TreeTableColumn colColumn = new TreeTableColumn("Col");
        colColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((LDIData)param.getValue().getValue())));
        colColumn.setCellFactory((Callback)new Callback<TreeTableColumn<LDIData, LDIData>, TreeTableCell<LDIData, LDIData>>(){

            public TreeTableCell<LDIData, LDIData> call(TreeTableColumn<LDIData, LDIData> p) {
                return new TreeTableCell<LDIData, LDIData>(){
                    private final Circle colPreview = new Circle(8.0, (Paint)Color.WHITE);

                    protected void updateItem(LDIData item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        int colId = -1;
                        if (item != null && !empty && (colId = item.getColId()) != -1) {
                            this.colPreview.setFill((Paint)GuiHelper.rgbaToColor((this).LDIGui.this.ctx.getRgbaColorByIds(colId, -1)));
                            this.setGraphic((Node)this.colPreview);
                            this.setText(Integer.toString(colId));
                            this.setTooltip(new Tooltip((this).LDIGui.this.ctx.getColorById((int)colId).name));
                        } else {
                            this.setBackground(null);
                            this.setText("");
                            this.setGraphic(null);
                            this.setTooltip(null);
                        }
                    }
                };
            }
        });
        colColumn.setPrefWidth(60.0);
        colColumn.setMinWidth(60.0);
        colColumn.setStyle("-fx-alignment: CENTER;");
        TreeTableColumn amountColumn = new TreeTableColumn("Amnt");
        amountColumn.setCellValueFactory(param -> {
            int amount = ((LDIData)param.getValue().getValue()).getAmount();
            if (amount != 0) {
                return new ReadOnlyStringWrapper(Integer.toString(amount));
            }
            return new ReadOnlyStringWrapper("");
        });
        amountColumn.setPrefWidth(50.0);
        amountColumn.setMinWidth(50.0);
        amountColumn.setStyle("-fx-alignment: CENTER-RIGHT;");
        this.tableView = new TreeTableView(this.elems);
        this.tableView.setShowRoot(false);
        this.tableView.setManaged(true);
        this.tableView.getColumns().add((Object)nameColumn);
        this.tableView.getColumns().add((Object)colColumn);
        this.tableView.getColumns().add((Object)amountColumn);
        this.tableView.setTableMenuButtonVisible(true);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.tableView.getSelectionModel().setCellSelectionEnabled(false);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((obs, oldSel, newSel) -> this.selUpdated((ObservableValue<? extends TreeItem<LDIData>>)obs, (TreeItem<LDIData>)oldSel, (TreeItem<LDIData>)newSel));
        center.getItems().add(this.tableView);
        HBox controlLine = new HBox();
        controlLine.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        controlLine.setSpacing(10.0);
        controlLine.setAlignment(Pos.CENTER_LEFT);
        controlLine.setMinSize(100.0, 30.0);
        content.setTop((Node)controlLine);
        controlLine.getChildren().add((Object)new Text("Workspace"));
        Button button = new Button("Load");
        button.setTooltip(new Tooltip("Load workspace, i.e. load configuration and item references from file"));
        button.setOnAction(event -> this.loadWorkspace());
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("Config.");
        button.setTooltip(new Tooltip("Configure workspace: define part sources and colors, activate web cache"));
        button.setOnAction(event -> this.configContext());
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("Save");
        button.setTooltip(new Tooltip("Save workspace, i.e. save configuration and item references to file"));
        button.setOnAction(event -> this.saveWorkspace());
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        controlLine.getChildren().add((Object)new Separator(Orientation.VERTICAL));
        controlLine.getChildren().add((Object)new Text("Items"));
        button = new Button("Clear");
        button.setTooltip(new Tooltip("Remove all items"));
        button.setOnAction(event -> this.elems.getChildren().clear());
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("Part-List");
        button.setTooltip(new Tooltip("Add a new part list that is editable"));
        button.setOnAction(event -> this.addPartList());
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("Part");
        button.setTooltip(new Tooltip("Add reference by name to part"));
        button.setOnAction(event -> this.addItem());
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("File");
        button.setTooltip(new Tooltip("Add reference to existing file"));
        button.setOnAction(event -> this.addFiles());
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("Directory");
        button.setTooltip(new Tooltip("Add reference to existing directory"));
        button.setOnAction(event -> this.addDir());
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        controlLine.getChildren().add((Object)new Separator(Orientation.VERTICAL));
        controlLine.getChildren().add((Object)new Text("LDI"));
        button = new Button("Refresh");
        button.setTooltip(new Tooltip("Refresh data items"));
        button.setOnAction(event -> this.refresh());
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("Info");
        button.setTooltip(new Tooltip("Show information about LDInspector"));
        button.setOnAction(event -> this.info());
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        button = new Button("Exit");
        button.setTooltip(new Tooltip("Exit LDInspector"));
        button.setOnAction(e -> {
            Window window = stage.getScene().getWindow();
            window.fireEvent((Event)new WindowEvent(window, WindowEvent.WINDOW_CLOSE_REQUEST));
        });
        button.setMaxHeight(Double.MAX_VALUE);
        controlLine.getChildren().add((Object)button);
        controlLine.getChildren().add((Object)new Separator(Orientation.VERTICAL));
        this.backgroundService = Executors.newFixedThreadPool(2);
        stage.setOnCloseRequest(e -> {
            this.backgroundService.shutdownNow();
            Platform.exit();
            try {
                this.backgroundService.awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        });
        controlLine.getChildren().add((Object)new Text("Bg.Act."));
        this.backgroundRemainingText = new Text("0");
        controlLine.getChildren().add((Object)this.backgroundRemainingText);
        this.tabPane = new TabPane();
        this.tabPane.setManaged(true);
        center.getItems().add((Object)this.tabPane);
        this.tabPane.getTabs().add((Object)this.createTab("Item", (Node)new LDIVItem(this)));
        this.tabPane.getTabs().add((Object)this.createTab("Edit", (Node)new LDIVEdit(this)));
        this.tabPane.getTabs().add((Object)this.createTab("OMR-Check", (Node)new LDIVCheck(this)));
        this.tabPane.getTabs().add((Object)this.createTab("Render", (Node)new LDIVRender(this)));
        this.tabPane.getTabs().add((Object)this.createTab("PartList", (Node)new LDIVPartList(this)));
        this.tabPane.getTabs().add((Object)this.createTab("PartGrid", (Node)new LDIVPartGrid(this)));
        this.tabPane.getTabs().add((Object)this.createTab("UsedFiles", (Node)new LDIVTUsedFiles(this)));
        this.tabPane.getTabs().add((Object)this.createTab("Source", (Node)new LDIVTSource(this)));
        this.tabPane.getTabs().add((Object)this.createTab("Search", (Node)new LDIVSearch(this)));
        this.tabPane.getTabs().add((Object)this.createTab("Web", (Node)new LDIVWeb(this)));
        this.log = new LDIVText();
        this.tabPane.getTabs().add((Object)this.createTab("Log", (Node)this.log));
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((obs, oldSel, newSel) -> this.tabChanged());
        this.tabChanged();
        this.progressModalPane = new VBox();
        this.progressModalPane.setSpacing(10.0);
        this.progressModalPane.setAlignment(Pos.CENTER);
        this.progressModalPane.setVisible(false);
        this.progressModalPane.setCursor(Cursor.WAIT);
        overlayStack.getChildren().add((Object)this.progressModalPane);
        this.progressModal = new ProgressIndicator();
        this.progressModalPane.getChildren().add((Object)this.progressModal);
        this.progressModalLabel = new Label();
        this.progressModalLabel.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.YELLOW, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.progressModalLabel.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.progressModalPane.getChildren().add((Object)this.progressModalLabel);
        this.scene = new Scene((Parent)overlayStack, 1280.0, 720.0, true);
        stage.setTitle("LDInspector");
        stage.setScene(this.scene);
        stage.show();
        LDrawPart wsp = LDIContext.loadDefaultContextFile();
        if (wsp != null) {
            this.loadWorkspace(wsp);
        } else {
            this.askExampleWorkspace();
        }
    }

    @Override
    public void log(String text) {
        this.log.log(text);
    }

    public boolean isRootItem(TreeItem<LDIData> item) {
        return this.elems.getChildren().contains(item);
    }

    public LDIDPartList getAsPartList(TreeItem<LDIData> item) {
        if (item == null) {
            return null;
        }
        LDIData data = (LDIData)item.getValue();
        if (data == null || !(data instanceof LDIDPartList)) {
            return null;
        }
        return (LDIDPartList)data;
    }

    public LDIDPartList getAsUnfixedPartList(TreeItem<LDIData> item) {
        LDIDPartList list = this.getAsPartList(item);
        if (list == null || list.isFixed()) {
            return null;
        }
        return list;
    }

    public void exportPartListAsPbg(LDIDPartList pl) {
        File f = GuiHelper.showFileSaveDialog("Export PBG-Part List", String.valueOf(pl.getName()) + ".pbg", true);
        if (f == null) {
            return;
        }
        try {
            PrintWriter w = new PrintWriter(new FileWriter(f));
            LDIPbgFiles.writeList(pl, w);
            w.close();
        }
        catch (IOException e) {
            GuiHelper.alert(Alert.AlertType.ERROR, "LDInspector: save PBG part list failed", "Writing PBG part list failed, because there was an I/O error", String.valueOf(e.getClass().getName()) + ": " + e.getMessage(), true);
            return;
        }
    }

    public void exportPartListAsXml(LDIDPartList pl) {
        File f = GuiHelper.showFileSaveDialog("Export XML-Part List", String.valueOf(pl.getName()) + ".xml", true);
        if (f == null) {
            return;
        }
        try {
            PrintWriter w = new PrintWriter(new FileWriter(f));
            LDIPbgFiles.writeList(pl, w);
            w.close();
        }
        catch (IOException e) {
            GuiHelper.alert(Alert.AlertType.ERROR, "LDInspector: save XML part list failed", "Writing XML part list failed, because there was an I/O error", String.valueOf(e.getClass().getName()) + ": " + e.getMessage(), true);
            return;
        }
    }

    public void removeItem(TreeItem<LDIData> item) {
        if (item == null) {
            return;
        }
        if (this.elems.getChildren().contains(item)) {
            this.elems.getChildren().remove(item);
            return;
        }
        TreeItem parent = item.getParent();
        if (parent == null || !this.isRootItem((TreeItem<LDIData>)parent)) {
            return;
        }
        LDIDPartList parentList = this.getAsUnfixedPartList((TreeItem<LDIData>)parent);
        if (parentList == null) {
            return;
        }
        parentList.removePart((LDIData)item.getValue());
        this.rebuildItem((TreeItem<LDIData>)parent);
    }

    public void rebuildItem(TreeItem<LDIData> item) {
        int selection = this.tableView.getSelectionModel().getSelectedIndex();
        TreeItem parent = item.getParent();
        if (parent == null) {
            return;
        }
        boolean parentExpaneded = parent.isExpanded();
        boolean itemExpanded = item.isExpanded();
        int index = parent.getChildren().indexOf(item);
        item = this.createDynamicNode((LDIData)item.getValue());
        item.setExpanded(true);
        parent.getChildren().set(index, item);
        parent.setExpanded(parentExpaneded);
        item.setExpanded(itemExpanded);
        this.tableView.getSelectionModel().clearAndSelect(selection);
        this.tableView.refresh();
    }

    public void refreshItem(TreeItem<LDIData> item) {
        if (item == null) {
            return;
        }
        ((DynamicTreeItem)item).isFirstTimeChildren = true;
        this.tableView.refresh();
        ObservableList tabs = this.tabPane.getTabs();
        for (Tab tab : tabs) {
            Node content;
            if (tab == null || !((content = tab.getContent()) instanceof LDIView)) continue;
            LDIView view = (LDIView)content;
            view.invalidateItem(item);
        }
    }

    public TreeItem<LDIData> getChangeableFile(TreeItem<LDIData> item) {
        if (item == null) {
            return null;
        }
        do {
            LDIData data;
            if ((data = (LDIData)item.getValue()) == null) {
                return null;
            }
            if (!(data instanceof LDIDFile)) continue;
            return item;
        } while ((item = item.getParent()) != null);
        return null;
    }

    public void reexportChangedFile(TreeItem<LDIData> item) {
        LDIData data;
        if (item == null || (data = (LDIData)item.getValue()) == null || !(data instanceof LDIDFile)) {
            return;
        }
        LDIDFile file = (LDIDFile)data;
        file.rebuildWithoutRefresh();
        if (!file.reexport(this.ctx)) {
            GuiHelper.alert(Alert.AlertType.ERROR, "Reexport failed", "Reexport of item " + data.getName() + " failed", "Please see log for details", true);
        }
        this.refreshItem(item);
    }

    public void addDataItem(LDIData data) {
        this.elems.getChildren().add(this.createDynamicNode(data));
        this.tableView.refresh();
    }

    public void runAndWait(final String text, final Task<?> task) {
        this.progressModalLabel.setText(text);
        this.progressModalPane.setVisible(true);
        this.progressModal.progressProperty().bind((ObservableValue)task.progressProperty());
        EventHandler<WorkerStateEvent> after = new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent event) {
                LDIGui.this.progressModal.progressProperty().unbind();
                LDIGui.this.progressModalPane.setVisible(false);
                Throwable e = task.getException();
                if (e != null) {
                    System.err.println("Exception in task " + text);
                    e.printStackTrace(System.err);
                }
            }
        };
        task.setOnSucceeded((EventHandler)after);
        task.setOnCancelled((EventHandler)after);
        task.setOnFailed((EventHandler)after);
        new Thread((Runnable)task).start();
    }

    public void runInBackground(final Runnable task) {
        final InterruptedException caller = new InterruptedException("caller trace");
        this.backgroundService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    caller.printStackTrace();
                }
            }
        });
    }

    public void updateBackgroundActivityCounter(int mod) {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Must be called from FX thread");
        }
        this.backgroundRemaining += mod;
        this.backgroundRemainingText.setText(Integer.toString(this.backgroundRemaining));
    }

    private Tab createTab(String title, Node content) {
        Tab tab = new Tab();
        tab.setText(title);
        tab.setClosable(false);
        tab.setContent(content);
        return tab;
    }

    private TreeItem<LDIData> createDynamicNode(LDIData d) {
        return new DynamicTreeItem(d);
    }

    private void askExampleWorkspace() {
        this.ctx = new LDIContext();
        this.buildObjects(0);
        this.contextChanged();
        if (GuiHelper.yesNo(Alert.AlertType.CONFIRMATION, "Workspace missing", "Workspace needs to be configured", "No workspace definition found, using example.\nYou may always do this later with button \"Config.\"\nDo you want to configure your workspace now?", false, false)) {
            this.configContext();
        } else {
            GuiHelper.fixPrimaryStage();
        }
    }

    private void buildObjects(int variant) {
        this.ctx.activateInternalColors();
        switch (variant) {
            default: {
                this.ctx.addSource(new LDICPTest(LDrawPartOrigin.SELF));
                LDIDLooseItem li = new LDIDLooseItem("3001.dat", 1, 1);
                this.elems.getChildren().add(this.createDynamicNode(li));
                li = new LDIDLooseItem("3003.dat", 2, 1);
                this.elems.getChildren().add(this.createDynamicNode(li));
                li = new LDIDLooseItem("3005.dat", 7, 1);
                this.elems.getChildren().add(this.createDynamicNode(li));
                li = new LDIDLooseItem("3795.dat", 14, 1);
                this.elems.getChildren().add(this.createDynamicNode(li));
                li = new LDIDLooseItem("model1.ldr", 16, 1);
                this.elems.getChildren().add(this.createDynamicNode(li));
                li = new LDIDLooseItem("model2.ldr", 16, 1);
                this.elems.getChildren().add(this.createDynamicNode(li));
                break;
            }
            case 1: {
                this.ctx.addSource(new LDICPZip("/home/smf/workspace/BrickUtils/complete.zip", LDrawPartOrigin.OFFICIAL));
                LDIDLooseItem li = new LDIDLooseItem("3003.dat", 2, 1);
                this.elems.getChildren().add(this.createDynamicNode(li));
                li = new LDIDLooseItem("3626ap01.dat", 14, 1);
                this.elems.getChildren().add(this.createDynamicNode(li));
                break;
            }
            case 2: {
                this.ctx.addSource(new LDICPDir("/home/smf/ldraw", LDrawPartOrigin.OFFICIAL));
                this.ctx.addSource(new LDICPZip("/home/smf/ldraw/Unofficial/ldrawunf.zip", LDrawPartOrigin.UNOFFICIAL));
                LDIDataSaveable li = new LDIDLooseItem("3003.dat", 3, 1);
                this.elems.getChildren().add(this.createDynamicNode(li));
                li = new LDIDLooseItem("3795.dat", 3, 1);
                this.elems.getChildren().add(this.createDynamicNode(li));
                li = new LDIDLooseItem("60481.dat", 7, 1);
                this.elems.getChildren().add(this.createDynamicNode(li));
                LDIDPartList testList = new LDIDPartList("PL 603-1 Sidecar");
                testList.addPart("3004.dat", 0, 1, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("3815c01.dat", 0, 1, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("3022.dat", 0, 1, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("3641.dat", 0, 3, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("193au.dat", 1, 1, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("3022.dat", 1, 1, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("3020.dat", 1, 2, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("8.dat", 1, 3, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("3660.dat", 1, 1, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("3024.dat", 7, 2, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("3623.dat", 7, 1, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("973c02.dat", 4, 1, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("3464.dat", 4, 3, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("3633.dat", 14, 2, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("3626ap01.dat", 14, 1, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("3795.dat", 14, 1, LDrawPartOrigin.UNRESOLVED, false);
                testList.addPart("3794a.dat", 14, 1, LDrawPartOrigin.UNRESOLVED, false);
                this.elems.getChildren().add(this.createDynamicNode(testList));
                li = new LDIDFile("/home/smf/omr/603-1 - Sidecar.mpd", this);
                this.elems.getChildren().add(this.createDynamicNode(li));
                li = new LDIDFile("/home/smf/Documents/Lego/LDCad_Parts_Bins/603-1-sidecar.pbg", this);
                this.elems.getChildren().add(this.createDynamicNode(li));
                li = new LDIDDirectory("/home/smf/omr", this);
                this.elems.getChildren().add(this.createDynamicNode(li));
                li = new LDIDDirectory("/home/smf/Documents/Lego/LDCad_Parts_Bins", this);
                this.elems.getChildren().add(this.createDynamicNode(li));
                li = new LDIDDirectory("/home/smf/ldraw/parts", this);
                this.elems.getChildren().add(this.createDynamicNode(li));
                li = new LDIDDirectory("/home/smf/Documents/Lego/OfficialModelRepository", this);
                this.elems.getChildren().add(this.createDynamicNode(li));
            }
        }
    }

    public void configContext() {
        LDIGConfigContext cd = new LDIGConfigContext(this);
        cd.showAndWait().ifPresent(nc -> {
            this.ctx = nc;
            this.contextChanged();
        });
        GuiHelper.fixPrimaryStage();
    }

    private void contextChanged() {
        for (TreeItem e : this.elems.getChildren()) {
            ((LDIData)e.getValue()).refresh();
        }
        this.tableView.refresh();
        this.tableView.getSelectionModel().clearSelection();
        for (Tab tab : this.tabPane.getTabs()) {
            Node content;
            if (tab == null || !((content = tab.getContent()) instanceof LDIView)) continue;
            LDIView view = (LDIView)content;
            view.contextChanged();
        }
    }

    private void loadWorkspace() {
        File f = GuiHelper.showFileOpenDialog("Load Context", true);
        if (f == null) {
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            LDrawPart rp = LDrawFiles.parseDef(f.getName(), br, LDrawPartOrigin.SELF, this);
            br.close();
            this.loadWorkspace(rp);
        }
        catch (IOException e) {
            GuiHelper.alert(Alert.AlertType.ERROR, "LDInspector: load workspace failed", "Loading context failed, because there was an I/O error", String.valueOf(e.getClass().getName()) + ": " + e.getMessage(), true);
            return;
        }
    }

    private void loadWorkspace(LDrawPart rp) {
        LDIContext nc = LDIContext.load(rp, this);
        if (nc != null) {
            this.ctx = nc;
            this.elems.getChildren().clear();
            List<LDIData> items = this.ctx.getDataItems(rp, this);
            for (LDIData item : items) {
                this.elems.getChildren().add(this.createDynamicNode(item));
            }
            this.contextChanged();
        }
    }

    private void saveWorkspace() {
        File f = GuiHelper.showFileSaveDialog("Save Workspace", LDIContext.defaultContextFilename, true);
        if (f == null) {
            return;
        }
        try {
            PrintWriter w = new PrintWriter(new FileWriter(f));
            ArrayList<LDIData> items = new ArrayList<LDIData>();
            for (TreeItem elem : this.elems.getChildren()) {
                items.add((LDIData)elem.getValue());
            }
            this.ctx.save(w, items, this);
            w.close();
        }
        catch (IOException e) {
            GuiHelper.alert(Alert.AlertType.ERROR, "LDInspector: save workspace failed", "Saving context failed, because there was an I/O error", String.valueOf(e.getClass().getName()) + ": " + e.getMessage(), true);
            return;
        }
    }

    private void addPartList() {
        this.elems.getChildren().add(this.createDynamicNode(new LDIDPartList("new")));
    }

    private void addItem() {
        this.elems.getChildren().add(this.createDynamicNode(new LDIDLooseItem("new", -1, 1)));
    }

    private void addFiles() {
        List<File> open = GuiHelper.showFileMultiOpenDialog("Add File(s) as Reference", true);
        if (open != null) {
            for (File f : open) {
                this.elems.getChildren().add(this.createDynamicNode(new LDIDFile(f.getAbsolutePath(), this.log)));
            }
        }
    }

    private void addDir() {
        File f = GuiHelper.showDirOpenDialog("Add Directory as Reference", true);
        if (f != null) {
            this.elems.getChildren().add(this.createDynamicNode(new LDIDDirectory(f.getAbsolutePath(), this.log)));
        }
    }

    private void refresh() {
        ArrayList list = new ArrayList(this.elems.getChildren());
        this.elems.getChildren().clear();
        this.ctx.dismissPartCache();
        for (TreeItem elem : list) {
            LDIData data = (LDIData)elem.getValue();
            data.refresh();
            this.elems.getChildren().add(this.createDynamicNode(data));
        }
        this.tableView.refresh();
        for (Tab tab : this.tabPane.getTabs()) {
            Node content;
            if (tab == null || !((content = tab.getContent()) instanceof LDIView)) continue;
            LDIView view = (LDIView)content;
            view.contextChanged();
        }
    }

    private void info() {
        GuiHelper.alertLargeContent(Alert.AlertType.INFORMATION, "LDInspector", "LDInspector Info", "Thank you for using LDInspector (" + LDInspector.version + ")\n" + "(c)2020 Stefan Frenz [smf]\n\n" + "This program may be useful for anything related to LDraw items,\n" + "especially organizing mpd-files and part lists.\n" + "All feedback is welcome, please use the corresponding LDraw forum thread.\n" + "For more information please visit https://forums.ldraw.org/\n" + "This software is released under GPLv3.\n\n" + "Special thanks to Philippe, Willy, Roland, Magnus and Johann for so many\n" + "helpful suggestions and patient explanation of OMR rules and LDraw format.\n\n" + "If you like LDraw, mpd-files and the Official Model Repository,\n" + "please consider looking at MPDCenter written by Michael Heidemann,\n" + "an excellent software that has another focus, is more tested,\n" + "and is commonly used by the LDraw community.\n\n" + "LDInspector makes use of a free json library from json.org to parse\n" + "json resources.\n\n" + "Running Java version: " + System.getProperty("java.runtime.version") + "\n" + "Running JavafX version: " + System.getProperty("javafx.runtime.version") + "\n" + "Running OS: " + System.getProperty("os.name") + " on " + System.getProperty("os.arch") + "\n", true);
    }

    private void tabChanged() {
        Tab curTab = (Tab)this.tabPane.getSelectionModel().getSelectedItem();
        ObservableList tabs = this.tabPane.getTabs();
        for (Tab tab : tabs) {
            Node content;
            if (tab == null || !((content = tab.getContent()) instanceof LDIView)) continue;
            LDIView view = (LDIView)content;
            view.onTabSelection(tab == curTab);
        }
    }

    private void selUpdated(ObservableValue<? extends TreeItem<LDIData>> obs, TreeItem<LDIData> oldSel, TreeItem<LDIData> newSel) {
        Tab curTab = (Tab)this.tabPane.getSelectionModel().getSelectedItem();
        ObservableList tabs = this.tabPane.getTabs();
        for (Tab tab : tabs) {
            Node content;
            if (tab == null || !((content = tab.getContent()) instanceof LDIView)) continue;
            LDIView view = (LDIView)content;
            view.selUpdated(obs, oldSel, newSel, tab == curTab);
        }
    }

    private class DynamicTreeItem
    extends TreeItem<LDIData> {
        private boolean isLeaf;
        private boolean isFirstTimeChildren;
        private boolean isFirstTimeLeaf;

        private DynamicTreeItem(LDIData data) {
            super((Object)data);
            this.isFirstTimeChildren = true;
            this.isFirstTimeLeaf = true;
        }

        public ObservableList<TreeItem<LDIData>> getChildren() {
            if (this.isFirstTimeChildren) {
                this.isFirstTimeChildren = false;
                final ObservableList sgc = super.getChildren();
                sgc.clear();
                final LDIData myData = (LDIData)this.getValue();
                LDIGui.this.runAndWait("Updating subparts...", new Task<Void>(){

                    protected Void call() throws Exception {
                        final List<? extends LDIData> se = myData.getSubElements(((DynamicTreeItem)DynamicTreeItem.this).LDIGui.this.ctx);
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (se != null) {
                                    for (LDIData cd : se) {
                                        sgc.add(LDIGui.this.createDynamicNode(cd));
                                    }
                                }
                            }
                        });
                        return null;
                    }
                });
            }
            return super.getChildren();
        }

        public boolean isLeaf() {
            if (this.isFirstTimeLeaf) {
                this.isFirstTimeLeaf = false;
                this.isLeaf = !((LDIData)this.getValue()).hasSubElements(LDIGui.this.ctx);
            }
            return this.isLeaf;
        }
    }
}

