/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import ldinsp.base.LDIWorkerColor;
import ldinsp.context.LDICColor;
import ldinsp.context.LDICColorHint;
import ldinsp.context.LDICColorHintSource;
import ldinsp.context.LDICColorProp;
import ldinsp.context.LDICPDir;
import ldinsp.context.LDICPTest;
import ldinsp.context.LDICPZip;
import ldinsp.context.LDICPartSource;
import ldinsp.context.LDIContext;
import ldinsp.ext.LDIBricklink;
import ldinsp.ext.LDIRebrickable;
import ldinsp.gui.GuiHelper;
import ldinsp.gui.LDIGui;
import ldinsp.ldraw.LDrawFiles;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDIGConfigContext
extends Dialog<LDIContext> {
    private static final String T_DIR = "Directory";
    private static final String T_ZIP = "ZIP-File";
    private static final String T_TEST = "Test";
    private static final String O_OFC = "ofc";
    private static final String O_UNO = "uno";
    private final LDIGui main;
    private final ComboBox<String> psOrigin;
    private final ComboBox<String> psType;
    private final Text psDestLabel;
    private final TextField psDest;
    private final Button psBrowse;
    private final ObservableList<LDICPartSource> partSources;
    private final TableView<LDICPartSource> partSourcesView;
    private final CheckBox webCacheActive;
    private final TextField webCachePath;
    private final TextField defaultAuthor;
    private final CheckBox colInternal;
    private final TextField colId;
    private final TextField colName;
    private final TextField colFace;
    private final TextField colEdge;
    private final TextField colHints;
    private final ComboBox<LDICColorProp> colProp;
    private final ObservableList<LDICColor> colors;
    private final TableView<LDICColor> colorsView;

    public LDIGConfigContext(LDIGui imain) {
        this.main = imain;
        DialogPane dialogPane = this.getDialogPane();
        this.setResizable(true);
        this.setHeaderText("Configure context");
        this.setTitle("LDInspector: configure context");
        VBox content = new VBox();
        content.setSpacing(10.0);
        dialogPane.setContent((Node)content);
        HBox line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        content.getChildren().add((Object)line);
        this.psOrigin = new ComboBox();
        line.getChildren().add((Object)this.psOrigin);
        this.psOrigin.getItems().addAll((Object[])new String[]{"official", "unofficial"});
        this.psOrigin.getSelectionModel().clearAndSelect(0);
        this.psType = new ComboBox();
        line.getChildren().add((Object)this.psType);
        this.psType.getItems().addAll((Object[])new String[]{T_DIR, T_ZIP, T_TEST});
        this.psType.getSelectionModel().clearAndSelect(0);
        this.psType.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> this.selType((String)newVal));
        this.psDestLabel = new Text("Path");
        line.getChildren().add((Object)this.psDestLabel);
        this.psDest = new TextField();
        line.getChildren().add((Object)this.psDest);
        this.psDest.setPrefWidth(400.0);
        this.psDest.setMinWidth(50.0);
        this.psDest.setMaxWidth(Double.MAX_VALUE);
        this.psDest.setTooltip(new Tooltip("absolute or relative pathname/filename to this part source"));
        HBox.setHgrow((Node)this.psDest, (Priority)Priority.ALWAYS);
        Button button = new Button("Add");
        line.getChildren().add((Object)button);
        button.setOnAction(event -> this.addSource());
        this.psBrowse = new Button("Browse+Add");
        line.getChildren().add((Object)this.psBrowse);
        this.psBrowse.setOnAction(event -> this.browseAddSource());
        this.partSources = FXCollections.observableArrayList(this.main.ctx.getSources());
        this.partSourcesView = new TableView(this.partSources);
        this.partSourcesView.setPrefHeight(200.0);
        this.partSourcesView.setMinHeight(200.0);
        this.partSourcesView.setPlaceholder((Node)new Text("no part sources configured"));
        content.getChildren().add(this.partSourcesView);
        TableColumn colAct = new TableColumn("Act.");
        colAct.setCellFactory((Callback)new Callback<TableColumn<LDICPartSource, Void>, TableCell<LDICPartSource, Void>>(){

            public TableCell<LDICPartSource, Void> call(TableColumn<LDICPartSource, Void> p) {
                return new TableCell<LDICPartSource, Void>(){
                    private final HBox box = new HBox();
                    private final Button up = new Button("up");
                    private final Button down = new Button("down");
                    private final Button del = new Button("del");
                    {
                        this.box.setSpacing(3.0);
                        this.box.getChildren().addAll((Object[])new Node[]{this.up, this.down, this.del});
                        this.up.setOnAction(event -> LDIGConfigContext.this.upSource(this.getIndex()));
                        this.down.setOnAction(event -> LDIGConfigContext.this.downSource(this.getIndex()));
                        this.del.setOnAction(event -> LDIGConfigContext.this.delSource(this.getIndex()));
                    }

                    protected void updateItem(Void item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            int ind = this.getIndex();
                            this.up.setDisable(ind == 0);
                            this.down.setDisable(ind == (this).LDIGConfigContext.this.partSources.size() - 1);
                            this.setGraphic((Node)this.box);
                        }
                    }
                };
            }
        });
        colAct.setSortable(false);
        colAct.setPrefWidth(150.0);
        colAct.setMinWidth(150.0);
        this.partSourcesView.getColumns().add((Object)colAct);
        TableColumn psStrCol = new TableColumn("Origin");
        psStrCol.setCellValueFactory(param -> {
            switch (((LDICPartSource)param.getValue()).origin) {
                case OFFICIAL: {
                    return new ReadOnlyStringWrapper(O_OFC);
                }
                case UNOFFICIAL: {
                    return new ReadOnlyStringWrapper(O_UNO);
                }
            }
            return new ReadOnlyStringWrapper("");
        });
        psStrCol.setCellFactory((Callback)new Callback<TableColumn<LDICPartSource, String>, TableCell<LDICPartSource, String>>(){

            public TableCell<LDICPartSource, String> call(TableColumn<LDICPartSource, String> p) {
                return new TableCell<LDICPartSource, String>(){

                    protected void updateItem(String item, boolean empty) {
                        block12: {
                            block10: {
                                super.updateItem((Object)item, empty);
                                if (item == null) break block10;
                                this.setText(item);
                                switch (item) {
                                    case "ofc": {
                                        this.setGraphic((Node)new Circle(8.0, (Paint)Color.LIGHTGREEN));
                                        this.setTooltip(new Tooltip("part is official"));
                                        break;
                                    }
                                    case "uno": {
                                        this.setGraphic((Node)new Circle(8.0, (Paint)Color.ORANGE));
                                        this.setTooltip(new Tooltip("part is unofficial"));
                                        break;
                                    }
                                    default: {
                                        this.setGraphic(null);
                                        this.setTooltip(null);
                                        break;
                                    }
                                }
                                break block12;
                            }
                            this.setText("");
                            this.setGraphic(null);
                            this.setTooltip(null);
                        }
                    }
                };
            }
        });
        psStrCol.setSortable(false);
        psStrCol.setPrefWidth(70.0);
        psStrCol.setMinWidth(70.0);
        this.partSourcesView.getColumns().add((Object)psStrCol);
        psStrCol = new TableColumn("Type");
        psStrCol.setCellValueFactory(param -> new ReadOnlyStringWrapper(((LDICPartSource)param.getValue()).getType()));
        psStrCol.setSortable(false);
        psStrCol.setPrefWidth(70.0);
        psStrCol.setMinWidth(70.0);
        this.partSourcesView.getColumns().add((Object)psStrCol);
        psStrCol = new TableColumn("Destination");
        psStrCol.setCellValueFactory(param -> new ReadOnlyStringWrapper(((LDICPartSource)param.getValue()).getDest()));
        psStrCol.setSortable(false);
        psStrCol.setPrefWidth(350.0);
        psStrCol.setMinWidth(250.0);
        this.partSourcesView.getColumns().add((Object)psStrCol);
        this.partSourcesView.getSelectionModel().selectedItemProperty().addListener((obs, oldSel, newSel) -> this.psSelUpdated((LDICPartSource)newSel));
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        content.getChildren().add((Object)line);
        this.webCacheActive = new CheckBox("Use cache for web resources");
        line.getChildren().add((Object)this.webCacheActive);
        String webCache = this.main.ctx.getWebCache();
        if (webCache != null) {
            this.webCacheActive.setSelected(true);
        } else {
            webCache = "";
        }
        this.webCachePath = new TextField(webCache);
        this.webCachePath.setPrefWidth(400.0);
        this.webCachePath.setMinWidth(50.0);
        this.webCachePath.setMaxWidth(Double.MAX_VALUE);
        this.webCachePath.setTooltip(new Tooltip("absolute or relative pathname/filename-prefix for web cached resources"));
        HBox.setHgrow((Node)this.webCachePath, (Priority)Priority.ALWAYS);
        this.webCachePath.textProperty().addListener((obs, oldVal, newVal) -> this.webCacheActive.setSelected(true));
        line.getChildren().add((Object)this.webCachePath);
        button = new Button("Browse");
        line.getChildren().add((Object)button);
        button.setOnAction(event -> {
            File f = GuiHelper.showDirOpenDialog("Set Web Cache Path", false);
            if (f != null) {
                String base = f.getAbsolutePath();
                if (!base.endsWith("/")) {
                    base = String.valueOf(base) + "/";
                }
                this.webCachePath.setText(base);
            }
        });
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        content.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Default author"));
        String defAuthor = this.main.ctx.getDefaultAuthor();
        if (defAuthor == null) {
            defAuthor = "";
        }
        this.defaultAuthor = new TextField(defAuthor);
        this.defaultAuthor.setPrefWidth(400.0);
        this.defaultAuthor.setMinWidth(50.0);
        this.defaultAuthor.setMaxWidth(Double.MAX_VALUE);
        this.defaultAuthor.setTooltip(new Tooltip("default author to be used when setting author"));
        HBox.setHgrow((Node)this.defaultAuthor, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)this.defaultAuthor);
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        content.getChildren().add((Object)line);
        this.colInternal = new CheckBox("Use internal color list");
        this.colInternal.setSelected(this.main.ctx.getInternalColorsState());
        line.getChildren().add((Object)this.colInternal);
        button = new Button("Clear all");
        line.getChildren().add((Object)button);
        button.setOnAction(event -> this.clearColorList());
        button = new Button("Add/update from internal list");
        line.getChildren().add((Object)button);
        button.setOnAction(event -> this.loadColorsFromInternalList());
        button = new Button("Add/update from LDraw file");
        line.getChildren().add((Object)button);
        button.setOnAction(event -> this.loadColorsFromFile());
        button = new Button("Web-update from Bricklink");
        line.getChildren().add((Object)button);
        button.setOnAction(event -> this.updateColorMappingForBricklink());
        button = new Button("Web-update from Rebrickable");
        line.getChildren().add((Object)button);
        button.setOnAction(event -> this.updateColorMappingForRebrickable());
        line = new HBox();
        line.setSpacing(10.0);
        line.setAlignment(Pos.CENTER_LEFT);
        content.getChildren().add((Object)line);
        line.getChildren().add((Object)new Text("Id"));
        this.colId = new TextField();
        line.getChildren().add((Object)this.colId);
        this.colId.setPrefWidth(50.0);
        this.colId.setMinWidth(50.0);
        this.colId.setTooltip(new Tooltip("decimal id"));
        line.getChildren().add((Object)new Text("Name"));
        this.colName = new TextField();
        line.getChildren().add((Object)this.colName);
        this.colName.setPrefWidth(200.0);
        this.colName.setMinWidth(80.0);
        this.colName.setTooltip(new Tooltip("name to be shown"));
        HBox.setHgrow((Node)this.colName, (Priority)Priority.ALWAYS);
        line.getChildren().add((Object)new Text("Face"));
        this.colFace = new TextField();
        line.getChildren().add((Object)this.colFace);
        this.colFace.setPrefWidth(100.0);
        this.colFace.setMinWidth(100.0);
        this.colFace.setTooltip(new Tooltip("hexadecimal RGBA value (order: RRGGBBAA) for faces"));
        line.getChildren().add((Object)new Text("Edge"));
        this.colEdge = new TextField();
        line.getChildren().add((Object)this.colEdge);
        this.colEdge.setPrefWidth(100.0);
        this.colEdge.setMinWidth(100.0);
        this.colEdge.setTooltip(new Tooltip("hexadecimal RGBA value (order: RRGGBBAA) for edges"));
        this.colProp = new ComboBox();
        line.getChildren().add((Object)this.colProp);
        this.colProp.getItems().addAll((Object[])LDICColorProp.values());
        this.colProp.getSelectionModel().clearAndSelect(0);
        this.colProp.setTooltip(new Tooltip("material"));
        this.colHints = new TextField();
        line.getChildren().add((Object)this.colHints);
        this.colHints.setPrefWidth(200.0);
        this.colHints.setMinWidth(80.0);
        this.colHints.setTooltip(new Tooltip("hint used for color mapping (\"comp1 id1 / id2 - name1 / name2 // comp2 id3 - name3\")"));
        button = new Button("Add/update");
        line.getChildren().add((Object)button);
        button.setOnAction(event -> this.addReplColor());
        this.colors = FXCollections.observableArrayList(this.main.ctx.getColors());
        this.colorsView = new TableView(this.colors);
        this.colorsView.setPrefHeight(300.0);
        this.colorsView.setMinHeight(200.0);
        this.colorsView.setPlaceholder((Node)new Text("no colors configured"));
        VBox.setVgrow(this.colorsView, (Priority)Priority.ALWAYS);
        content.getChildren().add(this.colorsView);
        TableColumn cStrCol = new TableColumn("Id");
        cStrCol.setCellValueFactory(param -> new ReadOnlyStringWrapper(Integer.toString(((LDICColor)param.getValue()).id)));
        cStrCol.setPrefWidth(70.0);
        cStrCol.setMinWidth(70.0);
        cStrCol.setStyle("-fx-alignment: CENTER-RIGHT;");
        cStrCol.setSortType(TableColumn.SortType.ASCENDING);
        cStrCol.setComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String id1, String id2) {
                return Integer.compare(Integer.parseInt(id1), Integer.parseInt(id2));
            }
        });
        this.colorsView.getColumns().add((Object)cStrCol);
        this.colorsView.getSortOrder().add((Object)cStrCol);
        cStrCol = new TableColumn("Name");
        cStrCol.setCellValueFactory(param -> new ReadOnlyStringWrapper(((LDICColor)param.getValue()).name));
        cStrCol.setPrefWidth(250.0);
        cStrCol.setMinWidth(180.0);
        this.colorsView.getColumns().add((Object)cStrCol);
        cStrCol = new TableColumn("Face");
        cStrCol.setCellValueFactory(param -> new ReadOnlyStringWrapper(String.format("%08X", ((LDICColor)param.getValue()).rgbaFace)));
        cStrCol.setCellFactory((Callback)new Callback<TableColumn<LDICColor, String>, TableCell<LDICColor, String>>(){

            public TableCell<LDICColor, String> call(TableColumn<LDICColor, String> p) {
                return new TableCell<LDICColor, String>(){
                    private final Circle colPreview = new Circle(8.0, (Paint)Color.WHITE);

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        int ind = this.getIndex();
                        if (ind >= 0 && ind < (this).LDIGConfigContext.this.colors.size()) {
                            int rgba = ((LDICColor)(this).LDIGConfigContext.this.colors.get((int)ind)).rgbaFace;
                            this.colPreview.setFill((Paint)GuiHelper.rgbaToColor(rgba));
                            this.setGraphic((Node)this.colPreview);
                            this.setText(String.format("%08X", rgba));
                        } else {
                            this.setBackground(null);
                            this.setText("");
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        cStrCol.setPrefWidth(100.0);
        cStrCol.setMinWidth(100.0);
        this.colorsView.getColumns().add((Object)cStrCol);
        cStrCol = new TableColumn("Edge");
        cStrCol.setCellValueFactory(param -> new ReadOnlyStringWrapper(String.format("%08X", ((LDICColor)param.getValue()).rgbaEdge)));
        cStrCol.setCellFactory((Callback)new Callback<TableColumn<LDICColor, String>, TableCell<LDICColor, String>>(){

            public TableCell<LDICColor, String> call(TableColumn<LDICColor, String> p) {
                return new TableCell<LDICColor, String>(){
                    private final Circle colPreview = new Circle(8.0, (Paint)Color.WHITE);

                    protected void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        int ind = this.getIndex();
                        if (ind >= 0 && ind < (this).LDIGConfigContext.this.colors.size()) {
                            int rgba = ((LDICColor)(this).LDIGConfigContext.this.colors.get((int)ind)).rgbaEdge;
                            this.colPreview.setFill((Paint)GuiHelper.rgbaToColor(rgba));
                            this.setGraphic((Node)this.colPreview);
                            this.setText(String.format("%08X", rgba));
                        } else {
                            this.setBackground(null);
                            this.setText("");
                            this.setGraphic(null);
                            this.setTooltip(null);
                        }
                    }
                };
            }
        });
        cStrCol.setPrefWidth(100.0);
        cStrCol.setMinWidth(100.0);
        this.colorsView.getColumns().add((Object)cStrCol);
        cStrCol = new TableColumn("Prop.");
        cStrCol.setCellValueFactory(param -> new ReadOnlyStringWrapper(((LDICColor)param.getValue()).prop.name()));
        cStrCol.setPrefWidth(80.0);
        cStrCol.setMinWidth(80.0);
        this.colorsView.getColumns().add((Object)cStrCol);
        cStrCol = new TableColumn("Hints");
        cStrCol.setCellValueFactory(param -> new ReadOnlyStringWrapper(LDICColorHint.hintsToString(((LDICColor)param.getValue()).hints)));
        cStrCol.setPrefWidth(550.0);
        cStrCol.setMinWidth(180.0);
        this.colorsView.getColumns().add((Object)cStrCol);
        this.colorsView.getSelectionModel().selectedItemProperty().addListener((obs, oldSel, newSel) -> this.colSelUpdated((LDICColor)newSel));
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        this.setResultConverter(bt -> {
            if (bt != null && bt.getButtonData() == ButtonBar.ButtonData.OK_DONE) {
                return this.buildContext();
            }
            return null;
        });
    }

    private LDIContext buildContext() {
        LDIContext ctx = new LDIContext();
        for (LDICPartSource ps : this.partSources) {
            ctx.addSource(ps);
        }
        ctx.setWebCache(this.webCacheActive.isSelected() ? this.webCachePath.getText() : null);
        String defAuthor = this.defaultAuthor.getText().trim();
        if (defAuthor.length() == 0) {
            defAuthor = null;
        }
        ctx.setDefaultAuthor(defAuthor);
        if (this.colInternal.isSelected()) {
            ctx.activateInternalColors();
        } else {
            ctx.addReplaceAllColors((List<LDICColor>)this.colors);
        }
        return ctx;
    }

    private void selType(String newVal) {
        if (newVal == null) {
            return;
        }
        switch (newVal) {
            case "Directory": {
                this.psDestLabel.setText("Path");
                this.psDest.setVisible(true);
                this.psBrowse.setVisible(true);
                break;
            }
            case "ZIP-File": {
                this.psDestLabel.setText("File");
                this.psDest.setVisible(true);
                this.psBrowse.setVisible(true);
                break;
            }
            case "Test": {
                this.psDestLabel.setText("");
                this.psDest.setVisible(false);
                this.psBrowse.setVisible(false);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void browseAddSource() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl29 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl29 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addSource() {
        LDrawPartOrigin origin = this.psOrigin.getSelectionModel().getSelectedIndex() != 0 ? LDrawPartOrigin.UNOFFICIAL : LDrawPartOrigin.OFFICIAL;
        switch ((String)this.psType.getSelectionModel().getSelectedItem()) {
            case "Directory": {
                this.partSources.add((Object)new LDICPDir(this.psDest.getText(), origin));
                break;
            }
            case "ZIP-File": {
                this.partSources.add((Object)new LDICPZip(this.psDest.getText(), origin));
                break;
            }
            case "Test": {
                this.partSources.add((Object)new LDICPTest(origin));
                break;
            }
            default: {
                return;
            }
        }
    }

    private void upSource(int index) {
        if (index > 0) {
            LDICPartSource ps = (LDICPartSource)this.partSources.remove(index);
            this.partSources.add(index - 1, (Object)ps);
        }
    }

    private void downSource(int index) {
        if (index < this.partSources.size() - 1) {
            LDICPartSource ps = (LDICPartSource)this.partSources.remove(index);
            this.partSources.add(index + 1, (Object)ps);
        }
    }

    private void delSource(int index) {
        this.partSources.remove(index);
    }

    private void psSelUpdated(LDICPartSource newSel) {
        if (newSel == null) {
            return;
        }
        if (newSel instanceof LDICPDir) {
            this.psType.getSelectionModel().clearAndSelect(0);
        } else if (newSel instanceof LDICPZip) {
            this.psType.getSelectionModel().clearAndSelect(1);
        } else if (newSel instanceof LDICPTest) {
            this.psType.getSelectionModel().clearAndSelect(2);
        }
        this.psDest.setText(newSel.getDest());
    }

    private void refreshColorList() {
        this.colorsView.refresh();
        this.colorsView.sort();
    }

    private void clearColorList() {
        this.colInternal.setSelected(false);
        this.colors.clear();
        this.refreshColorList();
    }

    private void loadColorsFromInternalList() {
        this.colInternal.setSelected(false);
        for (LDICColor col : LDICColor.getPredefinedColors()) {
            this.doAddReplColor(col);
        }
        this.refreshColorList();
    }

    private void loadColorsFromFile() {
        LDrawPart me = null;
        try {
            File f = GuiHelper.showFileOpenDialog("Import color config", false);
            if (f == null) {
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(f));
            me = LDrawFiles.parseDef("ColorConfig.ldr", br, LDrawPartOrigin.SELF, null);
            br.close();
        }
        catch (IOException e) {
            GuiHelper.alert(Alert.AlertType.ERROR, "LDInspector: import colors failed", "Import colors failed, because file could not be read", String.valueOf(e.getClass().getName()) + ": " + e.getMessage(), false);
            return;
        }
        this.colInternal.setSelected(false);
        this.colors.clear();
        LDIWorkerColor w = new LDIWorkerColor(null){

            @Override
            public void handleWorkedColor(LDICColor col) {
                LDIGConfigContext.this.doAddReplColor(col);
            }
        };
        w.work(me, false);
        this.refreshColorList();
    }

    private void updateColorMappingForBricklink() {
        List<LDICColorHint> hintList = null;
        try {
            hintList = LDIBricklink.loadColorMappingFromWeb();
        }
        catch (IOException e) {
            GuiHelper.alert(Alert.AlertType.ERROR, "LDInspector config: Rebrickable web color get failed", "I/O error during access to Rebrickable color table", String.valueOf(e.getClass().getName()) + ": " + e.getMessage(), false);
            return;
        }
        this.colInternal.setSelected(false);
        int updated = 0;
        for (LDICColorHint h : hintList) {
            LDICColor mod = this.searchColorByName(h.name);
            if (mod == null) continue;
            ++updated;
            this.colors.remove((Object)mod);
            ArrayList<LDICColorHint> hints = new ArrayList<LDICColorHint>();
            for (LDICColorHint o : mod.hints) {
                if (o.source == LDICColorHintSource.BRICKLINK) continue;
                hints.add(o);
            }
            hints.add(new LDICColorHint(LDICColorHintSource.BRICKLINK, h.id, h.name));
            this.colors.add((Object)new LDICColor(mod.id, mod.rgbaFace, mod.rgbaEdge, mod.prop, mod.name, hints));
        }
        this.refreshColorList();
        GuiHelper.alert(Alert.AlertType.INFORMATION, "LDInspector config: Bricklink web color get", "Bricklink web colors successfully imported", "Updated mappings for " + updated + " source-colors", false);
    }

    private void updateColorMappingForRebrickable() {
        List<List<LDICColorHint>> hintList = null;
        try {
            hintList = LDIRebrickable.loadColorMappingFromWeb();
        }
        catch (IOException e) {
            GuiHelper.alert(Alert.AlertType.ERROR, "LDInspector config: Rebrickable web color get failed", "I/O error during access to Rebrickable color table", String.valueOf(e.getClass().getName()) + ": " + e.getMessage(), false);
            return;
        }
        this.colInternal.setSelected(false);
        int updated = 0;
        if (hintList != null) {
            for (List<LDICColorHint> colHint : hintList) {
                LDICColorHint reb = null;
                for (LDICColorHint h : colHint) {
                    if (h.source != LDICColorHintSource.REBRICKABLE) continue;
                    reb = h;
                    break;
                }
                if (reb == null || reb.id < 0) continue;
                ArrayList<LDICColor> toClean = new ArrayList<LDICColor>();
                for (LDICColor chk : this.colors) {
                    if (!this.hasRebrickableHint(chk, reb.id)) continue;
                    toClean.add(chk);
                }
                this.colors.removeAll(toClean);
                for (LDICColor del : toClean) {
                    ArrayList<LDICColorHint> oldHints = new ArrayList<LDICColorHint>(del.hints);
                    ArrayList<LDICColorHint> newHints = new ArrayList<LDICColorHint>();
                    for (LDICColorHint h : oldHints) {
                        if (h.source == LDICColorHintSource.REBRICKABLE && h.id == reb.id) continue;
                        newHints.add(h);
                    }
                    this.colors.add((Object)new LDICColor(del.id, del.rgbaFace, del.rgbaEdge, del.prop, del.name, newHints));
                }
                ++updated;
                for (LDICColorHint h : colHint) {
                    LDICColor mod;
                    if (h.source != LDICColorHintSource.LDRAW || (mod = this.searchColorById(h.id)) == null) continue;
                    this.colors.remove((Object)mod);
                    ArrayList<LDICColorHint> hints = new ArrayList<LDICColorHint>(mod.hints);
                    hints.add(new LDICColorHint(LDICColorHintSource.REBRICKABLE, reb.id, reb.name));
                    this.colors.add((Object)new LDICColor(mod.id, mod.rgbaFace, mod.rgbaEdge, mod.prop, mod.name, hints));
                }
            }
        }
        this.refreshColorList();
        GuiHelper.alert(Alert.AlertType.INFORMATION, "LDInspector config: Rebrickable web color get", "Rebrickable web colors successfully imported", "Updated mappings for " + updated + " source-colors", false);
    }

    private boolean hasRebrickableHint(LDICColor c, int rid) {
        for (LDICColorHint h : c.hints) {
            if (h.source != LDICColorHintSource.REBRICKABLE || h.id != rid) continue;
            return true;
        }
        return false;
    }

    private LDICColor searchColorById(int id) {
        for (LDICColor chk : this.colors) {
            if (chk.id != id) continue;
            return chk;
        }
        return null;
    }

    private LDICColor searchColorByName(String name) {
        name = name.toLowerCase().replaceAll("[-_\\s]", "").replace('a', 'e').replaceAll("ou", "o");
        for (LDICColor chk : this.colors) {
            if (!chk.name.toLowerCase().replaceAll("[-_\\s]", "").replace('a', 'e').replaceAll("ou", "o").equals(name)) continue;
            return chk;
        }
        return null;
    }

    private void doAddReplColor(LDICColor col) {
        int i = this.colors.size() - 1;
        while (i >= 0) {
            if (((LDICColor)this.colors.get((int)i)).id == col.id) {
                this.colors.remove(i);
            }
            --i;
        }
        this.colors.add((Object)col);
    }

    private void addReplColor() {
        try {
            String name = this.colName.getText();
            if (name.length() == 0) {
                GuiHelper.alert(Alert.AlertType.ERROR, "LDInspector config: invalid name", "Color was not added because name is invalid", "Please use non-empty value for name", false);
                return;
            }
            int id = Integer.parseInt(this.colId.getText());
            int face = Integer.parseUnsignedInt(this.colFace.getText(), 16);
            int edge = Integer.parseUnsignedInt(this.colEdge.getText(), 16);
            this.colInternal.setSelected(false);
            LDICColor col = new LDICColor(id, face, edge, (LDICColorProp)((Object)this.colProp.getSelectionModel().getSelectedItem()), name, LDICColorHint.getHintsFromString(this.colHints.getText()));
            this.doAddReplColor(col);
            this.refreshColorList();
            this.colorsView.getSelectionModel().clearAndSelect(this.colors.indexOf((Object)col));
        }
        catch (NumberFormatException e) {
            GuiHelper.alert(Alert.AlertType.ERROR, "LDInspector config: invalid number", "Color was not added because number is invalid", "Please use decimal value for id\nand hexadecimal value for rgba values of face and edge\nin RRGGBBAA order\n\n" + e.getClass().getName() + ": " + e.getMessage(), false);
            return;
        }
    }

    private void colSelUpdated(LDICColor newSel) {
        if (newSel == null) {
            return;
        }
        this.colId.setText(Integer.toString(newSel.id));
        this.colName.setText(newSel.name);
        this.colFace.setText(String.format("%08X", newSel.rgbaFace));
        this.colEdge.setText(String.format("%08X", newSel.rgbaEdge));
        this.colProp.getSelectionModel().clearAndSelect(newSel.prop.ordinal());
        this.colHints.setText(LDICColorHint.hintsToString(newSel.hints));
    }
}

