/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ext;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import ldinsp.base.LDILogger;
import ldinsp.context.LDICColor;
import ldinsp.context.LDICColorHint;
import ldinsp.context.LDICColorHintSource;
import ldinsp.context.LDIContext;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIData;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDIXmlFiles {
    public static LDIDPartList parseDef(String listname, BufferedReader br, LDIContext ctx, LDILogger logger) throws IOException {
        String line;
        LDIDPartList me = new LDIDPartList(listname);
        boolean inInventory = false;
        boolean inItem = false;
        String itemType = null;
        String itemId = null;
        String minQty = null;
        String color = null;
        while ((line = br.readLine()) != null) {
            line = line.trim().toLowerCase();
            if (!inInventory) {
                if (!line.equals("<inventory>")) continue;
                inInventory = true;
                inItem = false;
                continue;
            }
            if (line.equals("</inventory>")) {
                inInventory = false;
                continue;
            }
            if (!inItem) {
                if (!line.equals("<item>")) continue;
                inItem = true;
                itemType = null;
                itemId = null;
                minQty = null;
                color = null;
                continue;
            }
            if (line.equals("</item>")) {
                inItem = false;
                if (itemType == null || !itemType.equals("p") || itemId == null || minQty == null || color == null) {
                    if (logger != null) {
                        logger.log("unsupported or incomplete item");
                    }
                    inItem = false;
                    continue;
                }
                try {
                    LDICColor col;
                    int amount = Integer.parseInt(minQty);
                    int blCol = Integer.parseInt(color);
                    int colId = blCol == 0 ? 16 : ((col = ctx.getColorByFirstHintId(blCol, LDICColorHintSource.BRICKLINK)) == null ? 16 : col.id);
                    me.addPart(String.valueOf(itemId) + ".dat", colId, amount, LDrawPartOrigin.UNRESOLVED, false);
                }
                catch (NumberFormatException e) {
                    if (logger == null) continue;
                    logger.log("invalid color/minqty number in item");
                }
                continue;
            }
            if (line.startsWith("<itemtype>")) {
                if (itemType != null) {
                    if (logger != null) {
                        logger.log("duplicate itemtype in item");
                    }
                    inItem = false;
                    continue;
                }
                itemType = LDIXmlFiles.getElement(line);
                continue;
            }
            if (line.startsWith("<itemid>")) {
                if (itemId != null) {
                    if (logger != null) {
                        logger.log("duplicate itemid in item");
                    }
                    inItem = false;
                    continue;
                }
                itemId = LDIXmlFiles.getElement(line);
                continue;
            }
            if (line.startsWith("<color>")) {
                if (color != null) {
                    if (logger != null) {
                        logger.log("duplicate color in item");
                    }
                    inItem = false;
                    continue;
                }
                color = LDIXmlFiles.getElement(line);
                continue;
            }
            if (!line.startsWith("<minqty>")) continue;
            if (minQty != null) {
                if (logger != null) {
                    logger.log("duplicate minqty in item");
                }
                inItem = false;
                continue;
            }
            minQty = LDIXmlFiles.getElement(line);
        }
        return me;
    }

    private static String getElement(String line) {
        int firstEnd = line.indexOf(62, 1);
        int secondStart = line.indexOf(60, firstEnd + 1);
        if (firstEnd < 0 || secondStart < 0) {
            return null;
        }
        return line.substring(firstEnd + 1, secondStart).trim();
    }

    public static void writeList(LDIDPartList pl, PrintWriter pw, LDIContext ctx, LDILogger logger) throws IOException {
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println("<INVENTORY>");
        for (LDIData lDIData : pl.getSubElements(ctx)) {
            String item = lDIData.getName();
            if (item == null) {
                if (logger == null) continue;
                logger.log("skipped element with null name");
                continue;
            }
            if (!(item = item.toLowerCase()).endsWith(".dat")) {
                if (logger == null) continue;
                logger.log("skipped " + item + " as it is not a .dat item");
                continue;
            }
            item = item.substring(item.length() - 4);
            int amount = lDIData.getAmount();
            if (amount < 1) {
                if (logger == null) continue;
                logger.log("skipped " + item + " as it has amount <1");
                continue;
            }
            int colId = lDIData.getColId();
            if (colId == -1) {
                colId = 0;
            } else {
                LDICColor color = ctx.getColorById(colId);
                LDICColorHint hint = color.getFirstHint(LDICColorHintSource.BRICKLINK);
                if (hint == null) {
                    if (logger != null) {
                        logger.log("could not find Bricklink color for " + colId + ", using 0");
                    }
                    colId = 0;
                } else {
                    colId = hint.id;
                }
            }
            pw.println("<ITEM>");
            pw.println("<ITEMTYPE>P</ITEMTYPE>");
            pw.println("<ITEMID>" + item + "</ITEMID>");
            pw.println("<COLOR>" + colId + "</COLOR>");
            pw.println("<MAXPRICE>-1.0000</MAXPRICE>");
            pw.println("<MINQTY>" + amount + "</MINQTY>");
            pw.println("<CONDITION>X</CONDITION>");
            pw.println("<NOTIFY>N</NOTIFY>");
            pw.println("</ITEM>");
        }
        pw.println("</INVENTORY>");
    }
}

