/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.ext;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import ldinsp.base.LDILogger;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIData;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDIPbgFiles {
    public static LDIDPartList parseDef(String listname, BufferedReader br, LDILogger logger) throws IOException {
        String line;
        LDIDPartList me = new LDIDPartList(listname);
        boolean header = true;
        while ((line = br.readLine()) != null) {
            int colpos;
            if ((line = line.trim()).length() == 0 || line.equals("0")) continue;
            if (header && line.startsWith("caption=")) {
                me.setDescription(line.substring(8));
                continue;
            }
            if (line.equalsIgnoreCase("<items>")) {
                header = false;
                continue;
            }
            if (header || (colpos = line.indexOf(58)) < 1) continue;
            String name = line.substring(0, colpos);
            line = line.substring(colpos + 1);
            int colId = LDIPbgFiles.getInt(line, "color");
            int amount = LDIPbgFiles.getInt(line, "count");
            if (colId == -1 || amount == -1) {
                logger.log("unrecognized / invalid pbg line: " + line);
                continue;
            }
            me.addPart(name, colId, amount, LDrawPartOrigin.UNRESOLVED, false);
        }
        me.fix();
        return me;
    }

    public static void writeList(LDIDPartList pl, PrintWriter pw) throws IOException {
        if (pl == null) {
            return;
        }
        String name = LDIPbgFiles.getCaption(pl.getName());
        pw.print("[options]\nkind=basic\ncaption=" + name + "\n" + "sortOn=description\n" + "\n" + "<items>\n");
        for (LDIData lDIData : pl.getSubElements(null)) {
            int amount = lDIData.getAmount();
            if (amount < 1) continue;
            pw.printf("%s:[sourceInv=parts] [color=%d] [count=%d]\n", lDIData.getName(), lDIData.getColId(), amount);
        }
    }

    private static int getInt(String all, String search) {
        int startPos = all.indexOf(search = "[" + search + "=");
        if (startPos == -1) {
            return -1;
        }
        int endPos = all.indexOf(93, startPos += search.length());
        if (endPos == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(all.substring(startPos, endPos));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static String getCaption(String name) {
        int pos = name.indexOf(46);
        if (pos < 0) {
            return name.trim();
        }
        return name.substring(0, pos).trim();
    }
}

