/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ldinsp.base.LDIWorkerRefWalk;
import ldinsp.context.LDIContext;
import ldinsp.data.LDIDExplicitItem;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIData;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;

public abstract class LDIDSingleItem
implements LDIData {
    protected LDrawPart part;
    protected String name;
    private int colId;
    private int amount;
    private ArrayList<LDIData> subPartCache;

    protected LDIDSingleItem(String iname, int icolId, int iamount) {
        this.name = iname;
        this.colId = icolId;
        this.amount = iamount;
    }

    @Override
    public boolean isRenderable(LDIContext ctx) {
        return true;
    }

    @Override
    public void refresh() {
        this.subPartCache = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription(LDIContext ctx) {
        if (this.part != null) {
            return this.part.description;
        }
        return null;
    }

    @Override
    public LDrawPart getPart(LDIContext ctx) {
        return this.part;
    }

    @Override
    public LDIDPartList getPartList(LDIContext ctx) {
        if (this.part == null) {
            return null;
        }
        if (this.part.loadedFromFilename != null && this.part.loadedFromFilename.toLowerCase().endsWith(".dat") || this.part.givenFilename != null && this.part.givenFilename.toLowerCase().endsWith(".dat")) {
            LDIDPartList pl = new LDIDPartList(this.name);
            pl.addPart(this.name, -1, this.amount, this.part.origin, true);
            return pl;
        }
        return new LDIDPartList(ctx, "PL " + this.name, this.part);
    }

    @Override
    public LDrawPartOrigin getPartOrigin(LDIContext ctx) {
        return this.part.origin;
    }

    @Override
    public boolean hasSubElements(LDIContext ctx) {
        return this.part != null && this.part.subParts != null && this.part.subParts.size() > 0;
    }

    public List<LDIData> getSubElements(LDIContext ctx) {
        if (this.subPartCache != null) {
            return this.subPartCache;
        }
        if (this.part == null || this.part.subParts == null || this.part.subParts.size() == 0) {
            return null;
        }
        this.subPartCache = new ArrayList();
        final HashMap counts = new HashMap();
        LDIWorkerRefWalk w = new LDIWorkerRefWalk(){

            @Override
            public LDrawPart usePart(String partName) {
                LDrawPart dest = null;
                for (LDrawPart sp : LDIDSingleItem.this.part.subParts) {
                    if (!sp.givenFilename.equalsIgnoreCase(partName)) continue;
                    dest = sp;
                    break;
                }
                if (dest == null) {
                    return null;
                }
                Integer cnt = (Integer)counts.get(dest);
                if (cnt == null) {
                    counts.put(dest, 1);
                } else {
                    counts.put(dest, cnt + 1);
                }
                return dest;
            }
        };
        w.work(this.part, false);
        for (LDrawPart sp : this.part.subParts) {
            Integer co = (Integer)counts.get(sp);
            int c = co != null ? co : 0;
            this.subPartCache.add(new LDIDExplicitItem(null, sp, -1, c));
        }
        return this.subPartCache;
    }

    @Override
    public void setColId(int col) {
        this.colId = col;
    }

    @Override
    public int getColId() {
        return this.colId;
    }

    @Override
    public void setAmount(int iamount) {
        this.amount = iamount;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }
}

