/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.data;

import java.util.List;
import ldinsp.base.LDILogger;
import ldinsp.context.LDIContext;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIDSingleItem;
import ldinsp.data.LDIData;
import ldinsp.data.LDIDataSaveable;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDIDLooseItem
extends LDIDSingleItem
implements LDIDataSaveable {
    private LDrawPartOrigin origin;

    public LDIDLooseItem() {
        super("", -1, 0);
    }

    public LDIDLooseItem(String iname, int icolId, int iamount) {
        this(iname, icolId, iamount, LDrawPartOrigin.UNRESOLVED);
    }

    public LDIDLooseItem(String iname, int icolId, int iamount, LDrawPartOrigin iorigin) {
        super(iname, icolId, iamount);
        this.origin = iorigin;
    }

    @Override
    public String getSaveString() {
        return this.name;
    }

    @Override
    public boolean needsSubPartSaving() {
        return false;
    }

    @Override
    public void restoreFromSaveString(int icolId, int iamount, String data, LDILogger logger) {
        this.setName(data);
        this.setColId(icolId);
        this.setAmount(iamount);
        this.refresh();
    }

    @Override
    public boolean restoreSubElements(List<LDIData> subs, LDILogger logger) {
        return false;
    }

    @Override
    public void refresh() {
        this.part = null;
        if (this.origin != LDrawPartOrigin.SELF) {
            this.origin = LDrawPartOrigin.UNRESOLVED;
        }
    }

    @Override
    public boolean isRenderable(LDIContext ctx) {
        return true;
    }

    @Override
    public boolean isRenameable() {
        return true;
    }

    @Override
    public void setName(String iname) {
        this.name = iname;
        this.refresh();
    }

    @Override
    public String getDescription(LDIContext ctx) {
        if (this.part == null) {
            this.resolveTarget(ctx);
        }
        return super.getDescription(ctx);
    }

    @Override
    public LDrawPart getPart(LDIContext ctx) {
        if (this.part == null) {
            this.resolveTarget(ctx);
        }
        return super.getPart(ctx);
    }

    @Override
    public LDIDPartList getPartList(LDIContext ctx) {
        if (this.part == null) {
            this.resolveTarget(ctx);
        }
        return super.getPartList(ctx);
    }

    @Override
    public boolean isAdjustable() {
        return true;
    }

    @Override
    public LDrawPartOrigin getPartOrigin(LDIContext ctx) {
        if (this.origin == null || this.origin == LDrawPartOrigin.UNRESOLVED) {
            if (this.part == null) {
                this.resolveTarget(ctx);
            }
            this.origin = this.part != null ? this.part.origin : LDrawPartOrigin.MISSING;
        }
        return this.origin;
    }

    @Override
    public boolean hasSubElements(LDIContext ctx) {
        if (this.part == null) {
            this.resolveTarget(ctx);
        }
        return super.hasSubElements(ctx);
    }

    private void resolveTarget(LDIContext ctx) {
        this.part = ctx.getPart(null, this.name, null);
    }
}

