/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveHint;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawPart;

public class LDICSubfilesUnique
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private ArrayList<LDICheckSolve> solver;

    public LDICSubfilesUnique(LDIContext ctx, LDrawPart part) {
        if (part.subParts == null) {
            this.resState = LDICheckState.IGN;
            this.resShort = " ign : file does not contain subparts, so no subpart unique name check\n";
            this.resLong = "";
            return;
        }
        StringBuffer lrsb = new StringBuffer();
        HashSet<String> names = new HashSet<String>();
        for (LDrawPart sb : part.subParts) {
            String name = sb.givenFilename;
            if (name == null) {
                this.resState = LDICheckState.ERROR;
                lrsb.append("missing given name in subpart starting in line " + this.getFirstLineNr(sb) + "\n");
                continue;
            }
            if (names.contains(name = name.toLowerCase())) {
                this.resState = LDICheckState.ERROR;
                lrsb.append("duplicate name for subpart " + name + " starting in line " + this.getFirstLineNr(sb) + "\n");
                continue;
            }
            names.add(name);
        }
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : subfile names are unique\n";
        } else {
            this.resShort = "error: at least one (sub)file name is missing or not unique\n";
            this.solver = new ArrayList();
            this.solver.add(new LDICheckSolveHint("Sub-name", "Subparts must have unique names"));
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    private int getFirstLineNr(LDrawPart p) {
        if (p.headers != null && p.headers.size() > 0) {
            return p.headers.get((int)0).lineNr;
        }
        if (p.actions != null && p.actions.size() > 0) {
            return p.actions.get((int)0).lineNr;
        }
        return 0;
    }
}

