/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveFix;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.data.LDIDPartList;
import ldinsp.data.LDIData;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;

public class LDICPartList
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private ArrayList<LDICheckSolve> solver;

    public LDICPartList(final LDIContext ctx, final LDIDPartList pl) {
        StringBuffer lrsb = new StringBuffer();
        HashSet checked = new HashSet();
        boolean hasUnresolved = false;
        boolean hasUnofficial = false;
        boolean hasMoved = false;
        for (LDIData lDIData : pl.getSubElements(ctx)) {
            String desc;
            String name = lDIData.getName();
            if (checked.contains(name)) continue;
            LDrawPart part = ctx.getPart(null, name, null);
            if (part == null) {
                hasUnresolved = true;
                lrsb.append("unresolveable part " + name + "\n");
                continue;
            }
            if (part.origin != LDrawPartOrigin.OFFICIAL) {
                hasUnofficial = true;
                lrsb.append("unoffical part " + name + "\n");
            }
            if ((desc = part.description) == null || !desc.toLowerCase().startsWith("~moved ")) continue;
            hasMoved = true;
            lrsb.append("moved part " + name + "\n");
        }
        if (hasUnresolved) {
            this.resState = LDICheckState.ERROR;
            this.resShort = "error: has unresolved parts\n";
        } else if (hasMoved || hasUnofficial) {
            this.resState = LDICheckState.WARN;
            this.resShort = " warn: has moved/unofficial parts\n";
            if (hasMoved && !pl.isFixed()) {
                this.solver = new ArrayList();
                this.solver.add(new LDICheckSolveFix("Moved", "Resolve moved parts"){

                    @Override
                    public int fix() {
                        return pl.resolveMoved(ctx);
                    }
                });
            }
        } else {
            this.resShort = "  ok : all parts are resoveable and official\n";
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }
}

