/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.List;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveFix;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawEdit;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawPart;

public class LDICLicenses
extends LDICheck {
    private static final String VALID_LICENSE_LINE = "0 !LICENSE Redistributable under CCAL version 2.0 : see CAreadme.txt";
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private List<LDICheckSolve> solver;

    public LDICLicenses(LDIContext ctx, final LDrawPart part) {
        StringBuffer lrsb = new StringBuffer();
        this.doCheckLicenseInHeader(part.headers, part.givenFilename, lrsb);
        if (part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                this.doCheckLicenseInHeader(sb.headers, sb.givenFilename, lrsb);
            }
        }
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : all files contain a valid license\n";
        } else {
            this.resShort = this.resState == LDICheckState.HINT ? " hint: at least one license could be optimized\n" : "error: at least one license missing or wrong\n";
            this.solver = new ArrayList<LDICheckSolve>();
            this.solver.add(new LDICheckSolveFix("License", "Set all licenses to be OMR compliant"){

                @Override
                public int fix() {
                    return LDrawEdit.setLicense(part, "Redistributable under CCAL version 2.0 : see CAreadme.txt", true, true, true);
                }
            });
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    private void doCheckLicenseInHeader(List<LDrawLine> lines, String name, StringBuffer lrsb) {
        int count = 0;
        boolean valid = false;
        boolean invalid = false;
        for (LDrawLine l : lines) {
            String lcl = l.source.toLowerCase();
            if (!lcl.startsWith("0 !license")) continue;
            ++count;
            if (l.source.equalsIgnoreCase(VALID_LICENSE_LINE)) {
                valid = true;
                continue;
            }
            invalid = true;
        }
        if (count == 1 && valid) {
            return;
        }
        if (count == 0) {
            lrsb.append("part " + name + " starting in line " + lines.get((int)0).lineNr + " has no license\n");
        }
        if (count > 1 && !invalid) {
            lrsb.append("part " + name + " starting in line " + lines.get((int)0).lineNr + " has multiple valid licenses\n");
            this.resState = this.resState.combine(LDICheckState.HINT);
            return;
        }
        if (count == 1) {
            lrsb.append("part " + name + " starting in line " + lines.get((int)0).lineNr + " has invalid license\n");
        } else if (invalid) {
            lrsb.append("part " + name + " starting in line " + lines.get((int)0).lineNr + " has multiple licenses, at least one of them is invalid\n");
        }
        this.resState = LDICheckState.ERROR;
    }
}

