/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.List;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveFix;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawEdit;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawPart;

public class LDICFilenameGivenname
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private ArrayList<LDICheckSolve> solver;

    public LDICFilenameGivenname(LDIContext ctx, final LDrawPart part) {
        String cmp = part.loadedFromFilename;
        StringBuffer lrsb = new StringBuffer();
        if (cmp == null) {
            this.resState = LDICheckState.IGN;
            this.resShort = " ign : part is not loaded from file, therefore filename is not checked\n";
            this.resLong = "";
            return;
        }
        if (part.givenFilename != null || part.subParts != null || cmp.endsWith(".mpd")) {
            this.check(part.givenFilename, part, lrsb);
            if (part.subParts != null) {
                for (LDrawPart sb : part.subParts) {
                    this.check(sb.givenFilename, sb, lrsb);
                }
            }
        } else {
            this.check(cmp, part, lrsb);
        }
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : all files have a valid name line\n";
        } else {
            this.resShort = "error: at least one (sub)file name does not match the corresponding filename\n";
            this.solver = new ArrayList();
            this.solver.add(new LDICheckSolveFix("Names", "Sync names with filenames"){

                @Override
                public int fix() {
                    return LDrawEdit.syncName(part, true);
                }
            });
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    private void check(String filename, LDrawPart part, StringBuffer lrsb) {
        String name = this.getName(part, lrsb);
        if (filename == null) {
            this.resState = LDICheckState.ERROR;
            lrsb.append("missing filename for " + part.givenFilename + "\n");
        }
        if (name == null) {
            this.resState = LDICheckState.ERROR;
            lrsb.append("missing name line for " + part.givenFilename + "\n");
        }
        if (filename == null || name == null) {
            return;
        }
        if (filename != null && name != null && filename.equals(name)) {
            return;
        }
        this.resState = LDICheckState.ERROR;
        lrsb.append("name \"" + name + "\" should match filename \"" + filename + "\" for " + part.givenFilename + "\n");
    }

    private String getName(LDrawPart part, StringBuffer lrsb) {
        int count = 0;
        String res = null;
        for (LDrawLine l : part.headers) {
            String lcl = l.source.toLowerCase();
            if (!lcl.startsWith("0 name: ")) continue;
            res = l.source.substring(8);
            ++count;
        }
        if (count == 1) {
            return res;
        }
        if (count == 0) {
            lrsb.append("item has no Name field\n");
        } else {
            lrsb.append("item has multiple Name fields\n");
        }
        this.resState = LDICheckState.ERROR;
        return null;
    }
}

