/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.check;

import java.util.ArrayList;
import java.util.List;
import ldinsp.check.LDICheck;
import ldinsp.check.LDICheckSolve;
import ldinsp.check.LDICheckSolveFix;
import ldinsp.check.LDICheckSolveHint;
import ldinsp.check.LDICheckState;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawEdit;
import ldinsp.ldraw.LDrawLine;
import ldinsp.ldraw.LDrawPart;

public class LDICAuthor
extends LDICheck {
    private LDICheckState resState = LDICheckState.OK;
    private String resShort;
    private String resLong;
    private ArrayList<LDICheckSolve> solver;

    public LDICAuthor(final LDIContext ctx, final LDrawPart part) {
        StringBuffer lrsb = new StringBuffer();
        this.doCheckAuthorInHeader(part, lrsb);
        if (part.subParts != null) {
            for (LDrawPart sb : part.subParts) {
                this.doCheckAuthorInHeader(sb, lrsb);
            }
        }
        if (this.resState == LDICheckState.OK) {
            this.resShort = "  ok : all files contain an author field\n";
        } else {
            this.resShort = this.resState == LDICheckState.HINT ? " hint: at least one (sub)file author field could be optimized\n" : "error: at least one (sub)file has no or multiple author fields\n";
            this.solver = new ArrayList();
            this.solver.add(new LDICheckSolveHint("Author", "Each part should have exactly one author line"));
            if (ctx.getDefaultAuthor() != null) {
                this.solver.add(new LDICheckSolveFix("Author", "Ensure exactly one author line"){

                    @Override
                    public int fix() {
                        return LDrawEdit.setAuthor(part, ctx.getDefaultAuthor(), true, false, true);
                    }
                });
            }
        }
        this.resLong = lrsb.toString();
    }

    @Override
    public LDICheckState getState() {
        return this.resState;
    }

    @Override
    public String getShortResult() {
        return this.resShort;
    }

    @Override
    public String getLongResult() {
        return this.resLong;
    }

    @Override
    public List<LDICheckSolve> getSolver() {
        return this.solver;
    }

    private void doCheckAuthorInHeader(LDrawPart part, StringBuffer lrsb) {
        ArrayList<LDrawLine> lines = part.headers;
        String name = part.givenFilename;
        String firstAuthor = null;
        int count = 0;
        boolean different = false;
        for (LDrawLine l : lines) {
            String lcl = l.source.toLowerCase();
            if (!lcl.startsWith("0 author: ")) continue;
            if (firstAuthor == null) {
                firstAuthor = lcl;
            } else if (!firstAuthor.equals(lcl)) {
                different = true;
            }
            ++count;
        }
        if (count == 1) {
            return;
        }
        if (count > 1 && !different) {
            lrsb.append("part " + name + " has multiple identical author fields\n");
            this.resState = this.resState.combine(LDICheckState.HINT);
            return;
        }
        if (count == 0) {
            lrsb.append("part " + name + " has no author field\n");
        } else {
            lrsb.append("part " + name + " has multiple author fields\n");
        }
        this.resState = LDICheckState.ERROR;
    }
}

