/*
 * Decompiled with CFR 0.152.
 */
package ldinsp.base;

import java.util.ArrayList;
import ldinsp.base.LDILogger;
import ldinsp.base.LDIWorker;
import ldinsp.context.LDICColor;
import ldinsp.context.LDICColorHint;
import ldinsp.context.LDICColorHintSource;
import ldinsp.context.LDICColorProp;
import ldinsp.ldraw.LDrawLineColor;
import ldinsp.ldraw.LDrawLineColorHint;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawPart;
import ldinsp.util.ColorHelper;

public abstract class LDIWorkerColor
extends LDIWorker {
    private final LDILogger logger;
    private final ArrayList<LDICColorHint> nextHints = new ArrayList();

    public abstract void handleWorkedColor(LDICColor var1);

    public LDIWorkerColor(LDILogger ilogger) {
        this.logger = ilogger;
    }

    @Override
    public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int ccolId, int pcol) {
        return null;
    }

    @Override
    public void handleColorHint(LDrawLineColorHint hint) {
        LDICColorHintSource hs = LDICColorHint.getHintSource(hint.comp);
        if (hs != null) {
            LDICColorHint.addHintsFromIdNameString(this.nextHints, hs, hint.idsNames);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handleColor(LDrawLineColor l) {
        alpha = 255;
        face = 0;
        edge = 0;
        prop = LDICColorProp.SOLID;
        try {
            i = 0;
            while (i < l.defs.length) {
                key = l.defs[i].toUpperCase();
                if (key.length() != 0) {
                    if (key.equals("VALUE")) {
                        face = Integer.parseInt(l.defs[++i].substring(1), 16);
                    } else if (key.equals("EDGE")) {
                        edge = Integer.parseInt(l.defs[++i].substring(1), 16);
                    } else if (key.equals("ALPHA")) {
                        alpha = Integer.parseInt(l.defs[++i]);
                    } else if (key.equals("LUMINANCE")) {
                        ++i;
                    } else {
                        if (!key.equals("MATERIAL")) {
                            if (key.equals("CHROME")) {
                                prop = LDICColorProp.CHROME;
                            } else if (key.equals("METAL")) {
                                prop = LDICColorProp.METAL;
                            } else if (key.equals("RUBBER")) {
                                prop = LDICColorProp.RUBBER;
                            } else if (key.equals("PEARLESCENT")) {
                                prop = LDICColorProp.PEARLESCENT;
                            } else if (this.logger != null) {
                                this.logger.log("error converting COLOUR line: unkown key");
                                return;
                            } else {
                                ** GOTO lbl39
                            }
                        }
                        break;
                    }
                }
lbl39:
                // 12 sources

                ++i;
            }
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            if (this.logger != null) {
                this.logger.log("error converting COLOUR line: " + e.getClass().getName() + ": " + e.getMessage());
            }
            return;
        }
        if (face == 0 || edge == 0) {
            if (this.logger != null) {
                this.logger.log("error converting COLOUR line: must have face+edge");
            }
            return;
        }
        c = new LDICColor(l.id, ColorHelper.getRgba(face, alpha), ColorHelper.getRgba(edge, alpha), prop, l.name, this.nextHints);
        this.nextHints.clear();
        this.handleWorkedColor(c);
    }
}

