/*
 * Decompiled with CFR 0.152.
 */
package ldinsp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import ldinsp.base.LDILogger;
import ldinsp.base.LDIWorker;
import ldinsp.colldet.Object3D;
import ldinsp.context.LDIContext;
import ldinsp.ldraw.LDrawFiles;
import ldinsp.ldraw.LDrawLinePartRef;
import ldinsp.ldraw.LDrawLineQuad;
import ldinsp.ldraw.LDrawLineTri;
import ldinsp.ldraw.LDrawPart;
import ldinsp.ldraw.LDrawPartOrigin;
import ldinsp.ldraw.LDrawPoint;

public class IntersectTest {
    public static final double TEST_TOLERANCE = 0.1;
    private static LDIContext ctx;
    private static LDILogger logger;
    private static int done;
    private static int good;
    private static int falsepos;
    private static int falseneg;

    public static void main(String[] args) {
        IntersectTest.init();
        IntersectTest.baseTests();
        IntersectTest.printStatistics();
    }

    public static void init() {
        LDrawPart wsp = LDIContext.loadDefaultContextFile();
        if (wsp == null) {
            System.out.println("no context");
            return;
        }
        ctx = LDIContext.load(wsp, null);
        logger = new LDILogger(){

            @Override
            public void log(String text) {
                System.out.println("log: " + text);
            }
        };
    }

    public static void printStatistics() {
        System.out.printf("done tests: %d/%d good, %d/%d fail (%d+%d false-negative+positive), prediction quality %d%% (%s)\n", good, done, done - good, done, falseneg, falsepos, (int)((double)good * 100.0 / (double)done), done == good ? "ok" : "fail");
    }

    public static void baseTests() {
        if (ctx == null) {
            System.out.println("init context first");
            return;
        }
        IntersectTest.test("simple1a", "1 7 0 0 0 1 0 0 0 1 0 0 0 1 3003.dat\n", "1 7 0 0 -45 1 0 0 0 1 0 0 0 1 3003.dat\n", true);
        IntersectTest.test("simple1b", "1 7 0 0 -10 1 0 0 0 1 0 0 0 1 3003.dat\n", "1 7 0 0 -45 1 0 0 0 1 0 0 0 1 3003.dat\n", false);
        IntersectTest.test("simple2a", "1 7 0 -13 -84 1 0 0 0 1 0 0 0 1 3005.dat\n", "1 7 0 0 -45 1 0 0 0 1 0 0 0 1 3003.dat\n", true);
        IntersectTest.test("simple2b", "1 7 0 -13 -84 1 0 0 0 1 0 0 0 1 3005.dat\n", "1 7 0 -24 -103 1 0 0 0 1 0 0 0 1 3005.dat\n", false);
        IntersectTest.test("simple2c", "1 7 0 -13 -84 1 0 0 0 1 0 0 0 1 3005.dat\n", "1 7 0 -24 -104 0.9998477 0 -0.01745241 0 1 0 0.01745241 0 0.9998477 3005.dat\n", false);
        IntersectTest.test("simple2d", "1 7 0 -13 -84 1 0 0 0 1 0 0 0 1 3005.dat\n", "1 7 0 -24 -104 1 0 0 0 0.9998477 -0.01745241 0 0.01745241 0.9998477 3005.dat\n", false);
        IntersectTest.test("simple3a", "1 0 0 -31 -51 1 0 0 0 1 0 0 0 1 3002.dat\n", "1 0 0 -55 -51 1 0 0 0 1 0 0 0 1 3002.dat\n", true);
        IntersectTest.test("simple3b", "1 0 0 -31 -51 1 0 0 0 1 0 0 0 1 3002.dat\n", "1 0 0 -54 -51 1 0 0 0 1 0 0 0 1 3002.dat\n", false);
        IntersectTest.test("simple3c", "1 0 0 -31 -51 1 0 0 0 1 0 0 0 1 3002.dat\n", "1 0 0 -55 -51 0.9998477 0 0.01745241 0 1 0 -0.01745241 0 0.9998477 3002.dat\n", false);
        IntersectTest.test("simple3d", "1 0 0 -31 -51 1 0 0 0 1 0 0 0 1 3002.dat\n", "1 0 0 -55 -51 0.9998477 -0.01745241 0 0.01745241 0.9998477 0 0 0 1 3002.dat\n", false);
        IntersectTest.test("simple4a", "1 0 0 -31 -51 1 0 0 0 1 0 0 0 1 3002.dat\n", "1 15 -10 -55 -51 1 0 0 0 1 0 0 0 1 6143.dat\n", true);
        IntersectTest.test("simple4b", "1 0 0 -31 -51 1 0 0 0 1 0 0 0 1 3002.dat\n", "1 15 -10 -55 -51 0.9998477 0 0.01745241 0 1 0 -0.01745241 0 0.9998477 6143.dat\n", false);
        IntersectTest.test("technik1a", "1 0 93 -27 -35 0 0 -1 0 1 0 1 0 0 3700.dat\n", "1 7 103 -17 -35 1 0 0 0 1 0 0 0 1 3749.dat\n", true);
        IntersectTest.test("technik1b", "1 0 93 -27 -35 0 0 -1 0 1 0 1 0 0 3700.dat\n", "1 7 103 -18 -35 1 0 0 0 1 0 0 0 1 3749.dat\n", false);
        IntersectTest.test("technik2a", "1 0 93 -27 -35 0 0 -1 0 1 0 1 0 0 3700.dat\n", "1 0 103 -17 -35 1 0 0 0 1 0 0 0 1 3705.dat\n", true);
        IntersectTest.test("technik2b", "1 0 93 -27 -35 0 0 -1 0 1 0 1 0 0 3700.dat\n", "1 0 103 -17 -36 1 0 0 0 1 0 0 0 1 3705.dat\n", false);
        IntersectTest.test("technik3a", "1 15 -10 -55 -51 1 0 0 0 1 0 0 0 1 6143.dat\n", "1 0 -10 -39 -51 0 0 -1 1 0 0 0 -1 0 3737.dat\n", true);
        IntersectTest.test("technik3b", "1 15 -10 -55 -51 0.9998477 0 0.01745241 0 1 0 -0.01745241 0 0.9998477 6143.dat\n", "1 0 -10 -39 -51 0 0 -1 1 0 0 0 -1 0 3737.dat\n", false);
        IntersectTest.test("technik3c", "1 15 -10 -55 -51 1 0 0 0 1 0 0 0 1 6143.dat\n", "1 0 -10 -39 -51 0 -0.01745241 -0.9998477 1 0 0 0 -0.9998477 0.01745241 3737.dat\n", false);
        IntersectTest.test("technik3d", "1 15 -10 -55 -51 0.9998477 0 -0.01745241 0 1 0 0.01745241 0 0.9998477 6143.dat\n", "1 0 -10 -39 -51 0 0.01745241 -0.9998477 1 0 0 0 -0.9998477 -0.01745241 3737.dat\n", true);
    }

    private static void test(String name, String o1, String o2, boolean ok) {
        LDrawPart p2;
        LDrawPart p1;
        try {
            p1 = LDrawFiles.parseDef("p1", new BufferedReader(new StringReader(o1)), LDrawPartOrigin.SELF, logger);
            p2 = LDrawFiles.parseDef("p2", new BufferedReader(new StringReader(o2)), LDrawPartOrigin.SELF, logger);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return;
        }
        PlainConverter w1 = new PlainConverter();
        w1.work(p1, false);
        PlainConverter w2 = new PlainConverter();
        w2.work(p2, false);
        Object3D ob1 = w1.obj;
        Object3D ob2 = w2.obj;
        int c1 = ob1.countIntersectingFaces(ob2, 0.1);
        int c2 = ob2.countIntersectingFaces(ob1, 0.1);
        int count = c1 + c2;
        if (c1 != c2) {
            System.out.print("! ");
        }
        System.out.print(String.valueOf(c1) + "+" + c2 + "=" + count + " => ");
        boolean res = count == 0;
        boolean valid = res == ok;
        ++done;
        if (valid) {
            ++good;
        } else if (res) {
            ++falsepos;
        } else {
            ++falseneg;
        }
        System.out.println(String.valueOf(name) + " done, valid==intersection-free: " + res + " (" + (valid ? "ok" : "fail, should be " + ok) + ")");
    }

    private static class PlainConverter
    extends LDIWorker {
        private Object3D obj = new Object3D();

        private PlainConverter() {
        }

        @Override
        public LDrawPart handlePartRef(LDrawLinePartRef ref, String partName, int colId, int pcol) {
            return ctx.getPart(null, partName, logger);
        }

        @Override
        public void handleTri(LDrawLineTri tri, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, int colId, int pcol) {
            if (this.getFaceInvertion()) {
                this.obj.addTri(t3, t1, t2);
            } else {
                this.obj.addTri(t1, t2, t3);
            }
        }

        @Override
        public void handleQuad(LDrawLineQuad quad, LDrawPoint t1, LDrawPoint t2, LDrawPoint t3, LDrawPoint t4, int colId, int pcol) {
            if (this.getFaceInvertion()) {
                this.obj.addTri(t3, t1, t2);
                this.obj.addTri(t2, t1, t4);
            } else {
                this.obj.addTri(t1, t2, t3);
                this.obj.addTri(t3, t4, t1);
            }
        }
    }
}

