#!/bin/bash
DIR=`dirname $(readlink -f "$0")`
cd "$DIR"
if [ ! -f "jdk-13.0.2/bin/java" ]; then
  echo "installing java to $DIR"
  notify-send "installing java to $DIR"
  wget https://download.java.net/java/GA/jdk13.0.2/d4173c853231432d94f001e99d882ca7/8/GPL/openjdk-13.0.2_linux-x64_bin.tar.gz || exit
  tar xzvf openjdk-13.0.2_linux-x64_bin.tar.gz
  rm openjdk-13.0.2_linux-x64_bin.tar.gz
  rm jdk-13.0.2/lib/src.zip
  echo "java successfully installed"
  notify-send "java successfully installed"
fi
if [ ! -f "javafx-sdk-13.0.2/lib/javafx.base.jar" ]; then
  echo "installing jfx to $DIR"
  notify-send "installing jfx to $DIR"
  wget https://download2.gluonhq.com/openjfx/13.0.2/openjfx-13.0.2_linux-x64_bin-sdk.zip || exit
  unzip openjfx-13.0.2_linux-x64_bin-sdk.zip
  rm openjfx-13.0.2_linux-x64_bin-sdk.zip
  rm javafx-sdk-13.0.2/lib/src.zip
  echo "jfx successfully installed"
  notify-send "jfx successfully installed"
fi
echo "java and jfx ok"
notify-send "java and jfx ok"
if [ -f "ldinsp.zip" ]; then
  mv ldinsp.zip ldinsp.jar
fi
if [ ! -f "ldinsp.jar" ]; then
  echo "downloading current version of LDInspector"
  wget http://fam-frenz.de/stefan/ldinsp.jar
fi
if [ ! -f "ldinsp.jar" ]; then
  echo "missing ldinsp.jar, please put it in $DIR"
  notify-send "missing ldinsp.jar, please put it in $DIR"
  exit
fi
echo "#!/bin/bash" > run.sh
echo "cd `dirname $(readlink -f "$0")`" >> run.sh
echo "jdk-13.0.2/bin/java --module-path .:javafx-sdk-13.0.2/lib/ -m LDInspector/ldinsp.LDInspector \"\$@\"" >> run.sh
chmod a+x run.sh
echo "run script created, please execute run.sh to start LDInspector"
notify-send "run script created, please execute run.sh to start LDInspector"

