package kernel;
//---------------------------------------------------------
// Pollin Board mit ATmega32
// LED1 an PD5(JP6)  LED2 an PD6(JP7)   Buzz an PD7(JP8)
// Jumper mssen geschlossen sein

public class Kernel {
  public static void main() {
            
    //enter start address
    MARKER.enterCodeAddr(AVR.STARTMETHOD, "Kernel", "main");

    //initialize port D directions Bit 6,7,8 (bzw PD5, PD6, PD7)
    MAGIC.wMem8(AVR.DDRD, (byte)0xE0 );
    
    //initialize default levels
    MAGIC.bitMem8(AVR.PORTD, (byte)0x40, true); // LED1 on
    MAGIC.bitMem8(AVR.PORTD, (byte)0x20, true); // LED2 on
   
    //init global vars
    initRAM();

    for (int i=0; i<1000000; i++) /*wait*/ ;
  
    //main loop
    while (true) {
      //switch LEDs
      MAGIC.bitMem8(AVR.PORTD, (byte)0x40, false);
      MAGIC.bitMem8(AVR.PORTD, (byte)0x20, true);
     
      for (int i=0; i<100000; i++) /*wait*/ ;

      //switch LEDs
      MAGIC.bitMem8(AVR.PORTD, (byte)0x40, true);
      MAGIC.bitMem8(AVR.PORTD, (byte)0x20, false);
 
      for (int i=0; i<100000; i++) /*wait*/ ;

      // Taste 1 abfragen PD2 und an PD7 ausgeben
      MAGIC.bitMem8(AVR.PORTD, (byte)0x80, (MAGIC.rMem8(AVR.PIND)&(byte)0x04)==(byte)0);
    }
  }

//---------------------------------------------------------------------
 
  private static void initRAM() {
    //initialize RAM
    short m, src, dst; 
    MARKER.inline();
    src=(short)MAGIC.getRamInitAddr();
    m=(short)((dst=(short)MAGIC.getRamAddr())+(short)MAGIC.getRamSize()+(short)MAGIC.getConstMemorySize());
    //while (dst<m) MAGIC.wMem8(dst++, rFlash8(src++));
    while (dst<m) MAGIC.wMem8(dst++, MAGIC.rIOs8(src++, 1)); 
  }
  
  /*
    private static byte rFlash8(short addr) {
    MARKER.inline();
    MAGIC.inlineOffset(0, addr, 0x81e8); //ldd r30,y+[addr]
    MAGIC.inlineOffset(1, addr, 0x81f8); //ldd r31,y+[addr]+1
    MAGIC.inline16(0x9105); //lpm r16,z+
    MARKER.stopBlockCoding();
    return (byte)0;
   }
 */
}
