package kernel;

//small SJC-example assuming a LED at PA2

public class Kernel {
  public static void main() {
    boolean state=false;
    
    //enter start address
    MARKER.enterCodeAddr(AVR.STARTMETHOD, "Kernel", "main"); //define start address in image
    
    //initialize default levels
    MAGIC.bitMem8(AVR.PORTA, (byte)0x04, state);

    //initialize port directions
    MAGIC.wMem8(AVR.DDRA, (byte)(0x01));
    
    //initialize gobals
    initRAM();
    
    //main loop
    while (true) {
      //toggle LED
      state=!state;
      MAGIC.bitMem8(AVR.PORTA, (byte)0x04, state);
      //wait a bit
      for (int i=0; i<10000; i++) { /*wait*/ }
    }
  }
  
  private static void initRAM() { //initialize RAM
    short m, src, dst;
    
    //inline the complete method
    MARKER.inline();
    
    //get start of RAM-init-area in flash
    src=(short)MAGIC.getRamInitAddr();
    
    //get maximum of RAM-init-area in flash
    m=(short)((dst=(short)MAGIC.getRamAddr())+(short)MAGIC.getRamSize()+(short)MAGIC.getConstMemorySize());
    
    //copy each byte from flash to RAM
    while (dst<m) MAGIC.wMem8(dst++, MAGIC.rIOs8(src++, 1));
    //old version using rFlash8 below: while (dst<m) MAGIC.wMem8(dst++, rFlash8(src++));
  }
  
  /*old version to read from flash, now MAGIC.rIOs(addr, 1) is available
  private static byte rFlash8(short addr) {
    MARKER.inline(); //inline the complete method
    MAGIC.inlineOffset(0, addr, 0x81e8); //ldd r30,y+[addr]
    MAGIC.inlineOffset(1, addr, 0x81f8); //ldd r31,y+[addr]+1
    MAGIC.inline16(0x9105);              //lpm r16,z+
    MARKER.stopBlockCoding(); //stop coding as result is already in target register 16
    return (byte)0;
  }*/
}
